/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception;

/**
 * The base class for all user defined business exception. DIF will process these errors and report them in a controlled
 * fashion to the user
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/05/06
 */
public abstract class AbstractCustomBusinessException extends Exception {

    /**  */
    private static final long serialVersionUID = -2561786144839344787L;

    /** The message title for presentation purposes */
    private String messageTitle = null;

    /**
     *
     */
    public AbstractCustomBusinessException()
    {
        super();
    }

    /**
     * @param arg0
     */
    public AbstractCustomBusinessException(String arg0)
    {
        super(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     */
    public AbstractCustomBusinessException(String arg0, Throwable arg1)
    {
        super(arg0, arg1);
    }

    /**
     * @param arg0
     */
    public AbstractCustomBusinessException(Throwable arg0)
    {
        super(arg0);
    }

    /**
     * Inspector for the 'messageTitle' attribute.
     * 
     * @return the messageTitle value
     */
    public String getMessageTitle()
    {
        return messageTitle;
    }

    /**
     * Modifier for the 'messageTitle' attribute.
     * 
     * @param messageTitle
     *            the new messageTitle value to set
     */
    public void setMessageTitle(String messageTitle)
    {
        this.messageTitle = messageTitle;
    }

}
