/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.dem.managers.ICustomFormManager;
import pt.digitalis.dif.dem.managers.impl.CustomFormManagerDummyImpl;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.dem.objects.parameters.IParameters;
import pt.digitalis.dif.dem.objects.parameters.ParametersImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintAlphabeticImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintEmailImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintMaxSizeImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintMinSizeImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintRegexImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateAbsoluteImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateInFutureImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateInPastImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateRelativeImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric.ParameterConstraintMaxImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric.ParameterConstraintMinImpl;
import pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric.ParameterConstraintNumericImpl;
import pt.digitalis.dif.dem.objects.parameters.rules.IParameterRule;
import pt.digitalis.dif.dem.objects.parameters.rules.ParameterRuleDependent;
import pt.digitalis.dif.dem.objects.parameters.rules.ParameterRuleExclusive;
import pt.digitalis.dif.dem.objects.parameters.types.BigDecimalParameter;
import pt.digitalis.dif.dem.objects.parameters.types.BooleanParameter;
import pt.digitalis.dif.dem.objects.parameters.types.DateParameter;
import pt.digitalis.dif.dem.objects.parameters.types.DocumentParameter;
import pt.digitalis.dif.dem.objects.parameters.types.DoubleParameter;
import pt.digitalis.dif.dem.objects.parameters.types.LongParameter;
import pt.digitalis.dif.dem.objects.parameters.types.StringParameter;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Contribution for parameter validation. Default constraints and validators
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public class ParametersModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {

        // Utilities
        binder.bind(IParameters.class, ParametersImpl.class);

        // Types
        binder.bind(IParameter.class, StringParameter.class).withId("string");
        binder.bind(IParameter.class, LongParameter.class).withId("long");
        binder.bind(IParameter.class, DoubleParameter.class).withId("double");
        binder.bind(IParameter.class, BooleanParameter.class).withId("boolean");
        binder.bind(IParameter.class, DateParameter.class).withId("date");
        binder.bind(IParameter.class, DocumentParameter.class).withId("document");
        binder.bind(IParameter.class, BigDecimalParameter.class).withId("bigdecimal");

        // Constraints
        binder.bind(IParameterConstraint.class, ParameterConstraintAlphabeticImpl.class).withId("alphabetic");
        binder.bind(IParameterConstraint.class, ParameterConstraintMinSizeImpl.class).withId("minsize");
        binder.bind(IParameterConstraint.class, ParameterConstraintMaxSizeImpl.class).withId("maxsize");

        binder.bind(IParameterConstraint.class, ParameterConstraintNumericImpl.class).withId("numeric");
        binder.bind(IParameterConstraint.class, ParameterConstraintMinImpl.class).withId("min");
        binder.bind(IParameterConstraint.class, ParameterConstraintMaxImpl.class).withId("max");

        binder.bind(IParameterConstraint.class, ParameterConstraintRegexImpl.class).withId("regex");
        binder.bind(IParameterConstraint.class, ParameterConstraintEmailImpl.class).withId("email");

        binder.bind(IParameterConstraint.class, ParameterConstraintDateImpl.class).withId("date");
        binder.bind(IParameterConstraint.class, ParameterConstraintDateRelativeImpl.class).withId("relativedate");
        binder.bind(IParameterConstraint.class, ParameterConstraintDateAbsoluteImpl.class).withId("absolutedate");
        binder.bind(IParameterConstraint.class, ParameterConstraintDateInPastImpl.class).withId("pastdate");
        binder.bind(IParameterConstraint.class, ParameterConstraintDateInFutureImpl.class).withId("futuredate");

        // Validators
        // binder.bind(IParameterValidator.class, ParameterValidatorXXXImpl.class).withId("xxx");

        // Rules
        binder.bind(IParameterRule.class, ParameterRuleDependent.class).withId("dependent");
        binder.bind(IParameterRule.class, ParameterRuleExclusive.class).withId("exclusive");

        // Form customization
        binder.bind(ICustomFormManager.class, CustomFormManagerDummyImpl.class).asSingleton();
    }
}
