package pt.digitalis.dif.sanitycheck.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.AnnotationTags;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 4 de Jul de 2011
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface SanityCheckTest {

    /**
     * The name of the test
     * 
     * @return the name
     */
    public String name() default AnnotationTags.NONE;

    /**
     * Defines if the method annotated needs an administrator user logged for execution
     * 
     * @return validation
     */
    public boolean onlyAdministrators() default false;
}
