/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when there is a search of a ContentItem in the repository and the ContentItem is not found
 * 
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class ContentItemNotFoundException extends ContentManagerException {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     */
    public ContentItemNotFoundException()
    {
        super("Content item not found");
    }

    /**
     * @param exception
     */
    public ContentItemNotFoundException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param contentId
     */
    public ContentItemNotFoundException(byte[] contentId)
    {
        super("Content not found with id: " + contentId);
    }

    /**
     * @param reason
     */
    public ContentItemNotFoundException(String reason)
    {
        super(reason);
    }
}
