/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when a user tries to delete a Node that has child Nodes. This only applies if the delete isn't
 * a cascade delete
 * 
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class NodeWithNodesException extends ContentManagerException {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     */
    public NodeWithNodesException()
    {
        super("Node has child nodes");
    }

    /**
     * @param exception
     */
    public NodeWithNodesException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param nodeId
     */
    public NodeWithNodesException(Long nodeId)
    {
        super("Node has child nodes. Id: " + nodeId);
    }

    /**
     * @param reason
     */
    public NodeWithNodesException(String reason)
    {
        super(reason);
    }

}
