/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.templates;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.interfaces.IApplicationPrivate;
import pt.digitalis.dif.dem.interfaces.IProvider;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.dif.exception.manager.RegistrationManagerException;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.Map;

/**
 * This class is a template for the IApplication interface method implementations. The CodeGen will copy these methods
 * to the class implementing the interface IApplication. Some methods will be copied "as is", other will be tweaked.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/06/01
 */
public class ApplicationCGTemplate implements IApplication, IApplicationPrivate
{

    /**
     * @see pt.digitalis.dif.dem.interfaces.IApplicationPrivate#__CG__initialize()
     */
    public void __CG__initialize()
    {
        // To be overrided with a call to the provided init method in the application with @Init
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getID()
     */
    public String getID()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()
     */
    public LicenseEditionType getLicenseEdition()
    {

        return TemplateResources.getRegistrationManager().getApplicationEdition(this.getID());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String)
     */
    public String getMessage(String messageID)
    {
        return getMessages().get(messageID);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessages()
     */
    public Map<String, String> getMessages()
    {
        return TemplateResources.getMessageManager()
                .getMessages(this, DIFGeneralConfigurationParameters.getInstance().getDefaultLanguage());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getName()
     */
    public String getName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()
     */
    public String getOriginalClassName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IApplication#getProvider()
     */
    public IProvider getProvider()
    {
        return TemplateResources.getDEMManager().getProvider(CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IApplication#getServices()
     */
    public Map<String, IService> getServices()
    {
        return TemplateResources.getDEMManager().getServices(this);
    }

    /**
     * @return an instance of template resources
     */
    protected TemplateResources getTemplateResources()
    {
        return TemplateResources.getInstance();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getUID()
     */
    public String getUID()
    {
        return "APPLICATION:" + this.getID();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()
     */
    public boolean isRegistered()
    {

        boolean result = this.getProvider().isRegistered();

        if (this.isRegistrable())
            result = TemplateResources.getRegistrationManager().isApplicationRegistered(this.getID());

        return result;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()
     */
    public boolean isRegistrable()
    {
        return TemplateResources.getRegistrationManager().isApplicationRegistrable(this.getID());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     */
    public boolean register(String name, String key) throws ConfigurationException
    {
        try
        {
            return TemplateResources.getRegistrationManager().registerApplication(getID(), name, key);
        }
        catch (RegistrationManagerException e)
        {
            DIFLogger.getLogger().debug(e);
            return false;
        }
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()
     */
    public void unregister() throws ConfigurationException
    {
        TemplateResources.getRegistrationManager().unregisterApplication(getID());
    }
}
