/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.templates;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.dem.CallbackType;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.EventType;
import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.ViewType;
import pt.digitalis.dif.dem.objects.parameters.IParameters;
import pt.digitalis.dif.exception.manager.RegistrationManagerException;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.inspection.ReflectionUtils;
import pt.digitalis.utils.inspection.exception.AuxiliaryOperationException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is a template for the IStage interface method implementations. The CodeGen will copy these methods to a
 * new Proxy class for each stage. Some methods will be copied "as is", other will be tweaked. These Proxy classes are
 * intended to be Singletons kept by the {@link pt.digitalis.dif.dem.interfaces.IDEMRegistry}
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007 /07/12
 */
public class StageCGTemplate implements IStage
{

    /**
     * Relates the exception types with the views for redirection purposes upon an exception raising. <K = Exception
     * FQN, V = Error view objects>
     */
    static public Map<String, ViewObject> errorViews;

    /** Controls the lazy initializations of this stage proxy... */
    static protected boolean isInitialized = false;

    /**
     * Relates the exception types with the stages for redirection purposes upon an exception raising. <K = Exception
     * FQN, V = stage id>
     */
    static private Map<String, String> errorStages;

    /** The list of registered event handlers */
    static private Map<EventType, List<String>> eventHandlers;

    /** The include message stages. */
    static private ArrayList<String> includeMessageStages = null;

    /** The list of injected stages */
    static private List<String> injectedStages;

    /** The list of injected views */
    static private List<ViewObject> injectedViews;

    /** The list of trusted parameters */
    static private ArrayList<String> trustedParameters = new ArrayList<String>();

    /** The parameters object */
    private IParameters parameters;

    /**
     * Adds a new event id to the known handlers
     *
     * @param type the event type to add
     * @param id   the id of the event
     */
    protected void addEvent(EventType type, String id)
    {
        eventHandlers.get(type).add(id);
    }

    /**
     * Allow access without valid consents boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()
     *         pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()
     */
    @Override
    public boolean allowAccessWithoutValidConsents()
    {
        return false;
    }

    /**
     * Creates a new view object. For usage of the CG methods
     *
     * @param engine    the engine of the view
     * @param type      the type of the view
     * @param target    the target resource/template of the view
     * @param isDefault T if the view is the default view
     *
     * @return the created view object
     */
    protected ViewObject createView(String engine, String type, String target, boolean isDefault)
    {
        return new ViewObject(engine, ViewType.valueOf(type), target, isDefault);
    }

    /** event handlers builder. Will be overridden in the CG if they exist */
    private void eventHandlersBuilder()
    {
        // By default do nothing
    }

    /**
     * Gets callback type.
     *
     * @return the callback type
     *
     * @see pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType() pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()
     */
    @Override
    public CallbackType getCallbackType()
    {
        return CallbackType.OFF;
    }

    /**
     * Gets default error stage.
     *
     * @return the default error stage
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorStage() pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorStage()pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorStage()pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorStage()
     */
    @Override
    public IStage getDefaultErrorStage()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_STAGE;
    }

    /**
     * Gets default error view.
     *
     * @return the default error view
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorView() pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorView()pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorView()pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorView()
     */
    @Override
    public ViewObject getDefaultErrorView()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * Gets default view.
     *
     * @return the default view
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getDefaultView() pt.digitalis.dif.dem.interfaces.IStage#getDefaultView()pt.digitalis.dif.dem.interfaces.IStage#getDefaultView()pt.digitalis.dif.dem.interfaces.IStage#getDefaultView()
     */
    @Override
    public ViewObject getDefaultView()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * Gets event handlers.
     *
     * @return the event handlers
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers() pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()
     */
    @Override
    synchronized public Map<EventType, List<String>> getEventHandlers()
    {
        if (eventHandlers == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            eventHandlers = new HashMap<EventType, List<String>>();

            eventHandlers.put(EventType.FORM_SUBMIT, new ArrayList<String>());
            eventHandlers.put(EventType.FORM_SUBMIT_AJAX_REQUEST, new ArrayList<String>());
            eventHandlers.put(EventType.FORM_SUBMIT_SAVE_ACTION, new ArrayList<String>());
            eventHandlers.put(EventType.FORM_VALIDATION, new ArrayList<String>());
            eventHandlers.put(EventType.AJAX_REQUEST, new ArrayList<String>());
            eventHandlers.put(EventType.DOCUMENT_TYPE, new ArrayList<String>());

            eventHandlersBuilder();
        }

        return eventHandlers;
    }

    /**
     * Gets id.
     *
     * @return the id
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getID() pt.digitalis.dif.dem.interfaces.IEntity#getID()pt.digitalis.dif.dem.interfaces.IEntity#getID()pt.digitalis.dif.dem.interfaces.IEntity#getID()
     */
    @Override
    public String getID()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * Gets included message stages.
     *
     * @return the included message stages
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages() pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages()pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages()pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages()
     */
    @Override
    public List getIncludedMessageStages()
    {
        if (includeMessageStages == null)
        {
            includeMessageStages = new ArrayList<String>();

            if (!CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE.equalsIgnoreCase(this.getOriginalClassName()))
            {
                try
                {
                    /*
                     * TODO: lpinto: pviegas For some reason when this method is called, the HolderRepository isn't
                     * initialized and a nullpointer happens when HolderRepository.addClass method is called. When
                     * HolderRepository.initializeInternals() is called, fromthis method, all works well. Must analyse
                     * why initialization wasn't arealdy made at the moment this method is called.
                     */
                    // HolderRepository.initializeInternals();
                    //
                    // ArrayList<String> includeMessageStagesTmp = new ArrayList<String>();
                    // ClassHolder classHolder = new ClassHolder(this.getOriginalClassName());
                    // Map<String, AnnotationHolder> annotationsMap = classHolder.getAnnotations();
                    //
                    // /* Cannot use directly the annotation */
                    // final String ANNOTATION_CANONICAL_NAME =
                    // "pt.digitalis.dif.dem.annotations.IncludeMessagesFromStages";
                    // if (annotationsMap.containsKey(ANNOTATION_CANONICAL_NAME))
                    // {
                    // AnnotationHolder annotationHolder = annotationsMap.get(ANNOTATION_CANONICAL_NAME);
                    // String messagesAnnotationValue = annotationHolder.getMembers().get("value").toString();
                    // if (StringUtils.isNotBlank(messagesAnnotationValue))
                    // {
                    // for (String stageID: messagesAnnotationValue.split(", "))
                    // {
                    // includeMessageStagesTmp.add(stageID);
                    // }
                    // }
                    // }
                    // includeMessageStages = includeMessageStagesTmp;
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                    // The class always exists
                }
            }
        }
        return includeMessageStages;
    }

    /**
     * Gets injected error stages.
     *
     * @return the injected error stages
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages() pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()
     */
    @Override
    synchronized public Map<String, String> getInjectedErrorStages()
    {
        if (errorStages == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            errorStages = new HashMap<String, String>();
            injectedErrorStagesBuilder();
        }

        return errorStages;
    }

    /**
     * Gets injected error views.
     *
     * @return the injected error views
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews() pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()
     */
    @Override
    synchronized public Map<String, ViewObject> getInjectedErrorViews()
    {
        if (errorViews == null)
        {
            errorViews = new HashMap<String, ViewObject>();
            injectedErrorViewsBuilder();
        }

        return errorViews;
    }

    /**
     * Gets injected stages.
     *
     * @return the injected stages
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedStages() pt.digitalis.dif.dem.interfaces.IStage#getInjectedStages()pt.digitalis.dif.dem.interfaces.IStage#getInjectedStages()pt.digitalis.dif.dem.interfaces.IStage#getInjectedStages()
     */
    @Override
    synchronized public List<String> getInjectedStages()
    {
        if (injectedStages == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            injectedStages = new ArrayList<String>();
            injectedStagesBuilder();
        }

        return injectedStages;
    }

    /**
     * Gets injected views.
     *
     * @return the injected views
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedViews() pt.digitalis.dif.dem.interfaces.IStage#getInjectedViews()pt.digitalis.dif.dem.interfaces.IStage#getInjectedViews()pt.digitalis.dif.dem.interfaces.IStage#getInjectedViews()
     */
    @Override
    synchronized public List<ViewObject> getInjectedViews()
    {
        if (injectedViews == null)
        {
            injectedViews = new ArrayList<ViewObject>();
            injectedViewsBuilder();
        }

        return injectedViews;
    }

    /**
     * Gets instance.
     *
     * @return the instance
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInstance() pt.digitalis.dif.dem.interfaces.IStage#getInstance()pt.digitalis.dif.dem.interfaces.IStage#getInstance()pt.digitalis.dif.dem.interfaces.IStage#getInstance()
     */
    @Override
    synchronized public IStageInstance getInstance()
    {
        IStageInstance instance;

        try
        {
            Class<?> clazz = Class.forName(getStageInstanceClassName());
            instance = (IStageInstance) ReflectionUtils.instantiateObjectFromClass(clazz);
        }
        catch (AuxiliaryOperationException e)
        {
            // This should never happen. If it does DIF will show the exception. Here we return null.
            return null;
        }
        catch (ClassNotFoundException e)
        {
            // This should never happen. If it does DIF will show the exception. Here we return null.
            return null;
        }

        instance.setProxy(this);

        if (!isInitialized)
            lazyStageProxyInitialization(instance);

        return instance;
    }

    /**
     * Gets java script head free marker template.
     *
     * @param view the view
     *
     * @return the java script head free marker template
     */
    @Override
    public String getJavaScriptHeadFreeMarkerTemplate(ViewObject view)
    {
        return TemplateResources.getJavaScriptHeadFreeMarkerTemplate(this, view);
    }

    /**
     * Gets java script head template.
     *
     * @param view the view
     *
     * @return the java script head template
     */
    @Override
    public String getJavaScriptHeadTemplate(ViewObject view)
    {
        return TemplateResources.getJavaScriptHeadTemplate(this, view);
    }

    /**
     * Gets java script on load free marker template.
     *
     * @param view the view
     *
     * @return the java script on load free marker template
     */
    @Override
    public String getJavaScriptOnLoadFreeMarkerTemplate(ViewObject view)
    {
        return TemplateResources.getJavaScriptOnLoadFreeMarkerTemplate(this, view);
    }

    /**
     * Gets java script on load template.
     *
     * @param view the view
     *
     * @return the java script on load template
     */
    @Override
    public String getJavaScriptOnLoadTemplate(ViewObject view)
    {
        return TemplateResources.getJavaScriptOnLoadTemplate(this, view);
    }

    /**
     * Gets java script templates.
     *
     * @return the java script templates
     */
    @Override
    public Map<String, Map<String, String>> getJavaScriptTemplates()
    {
        return TemplateResources.getJavaScriptTemplatesByViewForStage(this);
    }

    /**
     * Gets license edition.
     *
     * @return the license edition
     *
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition() pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()
     */
    @Override
    public LicenseEditionType getLicenseEdition()
    {
        return TemplateResources.getRegistrationManager().getStageEdition(this.getID());
    }

    /**
     * Gets message for language.
     *
     * @param language  the language
     * @param messageID the message id
     *
     * @return the message for language
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     */
    @Override
    public String getMessageForLanguage(String language, String messageID)
    {
        return getMessagesForLanguage(language).get(messageID);
    }

    /**
     * Gets messages for language.
     *
     * @param language the language
     *
     * @return the messages for language
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     */
    @Override
    public Map<String, String> getMessagesForLanguage(String language)
    {
        return TemplateResources.getMessageManager().getMessages(this, language);
    }

    /**
     * Gets name.
     *
     * @return the name
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getName() pt.digitalis.dif.dem.interfaces.IEntity#getName()pt.digitalis.dif.dem.interfaces.IEntity#getName()pt.digitalis.dif.dem.interfaces.IEntity#getName()
     */
    @Override
    public String getName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * Gets original class name.
     *
     * @return the original class name
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName() pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()
     */
    @Override
    public String getOriginalClassName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * Gets overrides stage id.
     *
     * @return the overrides stage id
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID() pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()
     */
    @Override
    public String getOverridesStageID()
    {
        return null;
    }

    /**
     * Gets parameters.
     *
     * @return the parameters
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getParameters() pt.digitalis.dif.dem.interfaces.IStage#getParameters()pt.digitalis.dif.dem.interfaces.IStage#getParameters()pt.digitalis.dif.dem.interfaces.IStage#getParameters()
     */
    @Override
    synchronized public IParameters getParameters()
    {
        if (parameters == null)
        {
            parameters = getTemplateResources().getParametersInstance(getInstance());
            // TODO: Refactor the IParameterImpl so that we can access the parameter list with initializing a
            // StageInstance parameters.initialize(this);
        }

        return parameters;
    }

    /**
     * Gets service.
     *
     * @return the service
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getService() pt.digitalis.dif.dem.interfaces.IStage#getService()pt.digitalis.dif.dem.interfaces.IStage#getService()pt.digitalis.dif.dem.interfaces.IStage#getService()
     */
    @Override
    public IService getService()
    {
        return TemplateResources.getDEMManager().getService(CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE);
    }

    /**
     * Gets stage instance class name.
     *
     * @return the stage instance class name
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName() pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()
     */
    @Override
    public String getStageInstanceClassName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * For usage of the CG methods
     *
     * @return an instance of template resources
     */
    protected TemplateResources getTemplateResources()
    {
        return TemplateResources.getInstance();
    }

    /**
     * Gets trusted parameters.
     *
     * @return the trusted parameters
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters() pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters()pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters()pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters()
     */
    @Override
    public List<String> getTrustedParameters()
    {
        if (trustedParameters == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            trustedParameters = new ArrayList<String>();
            trustedParametersBuilder();
        }

        return trustedParameters;
    }

    /**
     * Gets uid.
     *
     * @return the uid
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getUID() pt.digitalis.dif.dem.interfaces.IEntity#getUID()pt.digitalis.dif.dem.interfaces.IEntity#getUID()pt.digitalis.dif.dem.interfaces.IEntity#getUID()
     */
    @Override
    public String getUID()
    {
        return "STAGE:" + this.getID();
    }

    /**
     * Has authentication boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthentication() pt.digitalis.dif.dem.interfaces.IStage#hasAuthentication()pt.digitalis.dif.dem.interfaces.IStage#hasAuthentication()pt.digitalis.dif.dem.interfaces.IStage#hasAuthentication()
     */
    @Override
    public boolean hasAuthentication()
    {
        return true;
    }

    /**
     * Has authentication error injection boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()
     *         pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()
     */
    @Override
    public boolean hasAuthenticationErrorInjection()
    {
        return false;
    }

    /**
     * Has authorization boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization() pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()
     */
    @Override
    public boolean hasAuthorization()
    {
        return true;
    }

    /**
     * Has callback enabled boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled() pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()
     */
    @Override
    public boolean hasCallbackEnabled()
    {
        return false;
    }

    /**
     * Has injected contributions boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions() pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()
     */
    @Override
    public boolean hasInjectedContributions()
    {
        return false;
    }

    /**
     * Has java script head freemarker template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptHeadFreeMarkerTemplate(ViewObject view)
    {
        return StringUtils.isNotBlank(this.getJavaScriptHeadFreeMarkerTemplate(view));
    }

    /**
     * Has java script head template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptHeadTemplate(ViewObject view)
    {
        return StringUtils.isNotBlank(this.getJavaScriptHeadTemplate(view));
    }

    /**
     * Has java script on load freemarker template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptOnLoadFreeMarkerTemplate(ViewObject view)
    {
        return StringUtils.isNotBlank(this.getJavaScriptOnLoadFreeMarkerTemplate(view));
    }

    /**
     * Has java script on load template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptOnLoadTemplate(ViewObject view)
    {
        return StringUtils.isNotBlank(this.getJavaScriptOnLoadTemplate(view));
    }

    /**
     * Has parameter error injection boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection() pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()
     */
    @Override
    public boolean hasParameterErrorInjection()
    {
        // By default returns false. If the stage implementation injects the parameter errors, that this is overwritten
        // with 'true'
        return false;
    }

    /**
     * Has validation logic for form boolean.
     *
     * @param formName the form name
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     */
    @Override
    public boolean hasValidationLogicForForm(String formName)
    {
        return this.getEventHandlers().get(EventType.FORM_VALIDATION).contains(formName);
    }

    /** Injected Error Stages builder. Will be overridden in the CG if stages are injected */
    private void injectedErrorStagesBuilder()
    {
    }

    /** Injected Views builder. Will be overridden in the CG if stages are injected */
    private void injectedErrorViewsBuilder()
    {
    }

    /** Injected Stages builder. Will be overridden in the CG if stages are injected */
    private void injectedStagesBuilder()
    {
    }

    /** Injected Views builder. Will be overridden in the CG if stages are injected */
    private void injectedViewsBuilder()
    {
    }

    /**
     * Is registered boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered() pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()
     */
    @Override
    public boolean isRegistered()
    {
        boolean result = this.getService().isRegistered();

        if (this.isRegistrable())
            result = TemplateResources.getRegistrationManager().isStageRegistered(getID());

        return result;
    }

    /**
     * Is registrable boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable() pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()
     */
    @Override
    public boolean isRegistrable()
    {
        return TemplateResources.getRegistrationManager().isStageRegistrable(getID());
    }

    /**
     * The lazy initializations for all stages. Things that require all DEM entities to be previously initialized
     *
     * @param stage the stage instance for accessing some stage properties in the initialization process
     */
    protected void lazyStageProxyInitialization(IStageInstance stage)
    { // FIXME: lazyStageProxyInitialization is generating errors
        /*
         * try { for (IParameter<?> parameter:
         * stage.getParameters().getAllAvailableParameters().getParameters().values()) if (parameter.getRules() != null
         * && parameter.getRules().size() > 0) for (IParameterRule<?> rule: parameter.getRules()) {
         * AbstractParameterRule<?> ruleInstance = (AbstractParameterRule<?>) rule; for (String linkedParameterID:
         * ruleInstance.getParameters()) getParameters().getAllAvailableParameters().getParameter(linkedParameterID)
         * .setReferencedInARuleFromAnotherParameter(true); } } catch (ParameterException e) {
         * DIFLogger.getLogger().info("Could not initialize stage parameters: " + e.getMessage()); }
         */
        isInitialized = true;
    }

    /**
     * Register boolean.
     *
     * @param name the name
     * @param key  the key
     *
     * @return the boolean
     *
     * @exception ConfigurationException the configuration exception
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     */
    @Override
    public boolean register(String name, String key) throws ConfigurationException
    {
        try
        {
            return TemplateResources.getRegistrationManager().registerStage(getID(), name, key);
        }
        catch (RegistrationManagerException e)
        {
            DIFLogger.getLogger().debug(e);
            return false;
        }
    }

    /** Trusted parameters builder. Will be overridden in the CG if stages are injected */
    private void trustedParametersBuilder()
    {
    }

    /**
     * Unregister.
     *
     * @exception ConfigurationException the configuration exception
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#unregister() pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()
     */
    @Override
    public void unregister() throws ConfigurationException
    {
        TemplateResources.getRegistrationManager().unregisterStage(getID());
    }
}