/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.templates;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.dem.CallbackType;
import pt.digitalis.dif.dem.annotations.parameter.CustomParameters;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.EventType;
import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.ViewType;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.dem.objects.parameters.IParameters;
import pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors;
import pt.digitalis.dif.dem.objects.parameters.rules.IParameterRule;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is a template for the IStageInstance interface method implementations. The CodeGen will copy these methods
 * to a new Instance class for each stage. Some methods will be copied "as is", others will be tweaked.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007 /07/12
 */
public class StageInstanceCGTemplate implements IStageInstance
{

    /**
     * A set of custom messages that will only persist in the life cycle of this stage instance and them are discarded.
     * These will be added through the special messages maps that all getMessages like return
     */
    private Map<String, String> __customMessages;

    /** The errors of the parameter processing */
    private ControllerException _CG_authenticationException;

    /** The execution context. */
    private IDIFContext _CG_context;

    /** T if the stage jas an annotated {@link CustomParameters} method */
    private boolean _CG_hasCustomParameters = false;

    /** The errors of the parameter processing */
    private ParameterErrors _CG_parameterErrors;

    /** The parameters object */
    private IParameters _CG_parameters;

    /** the _CG_proxy instance */
    private IStage _CG_proxy;

    /** the active/present features */
    private List<String> activeStageFeatures = null;

    /** T if the stage has already been initialized by calling the "_CG_init" method */
    private boolean isInitialized;

    /**
     * a private instance of template resources. Used for optimizations and live debug purposes instead of direct code
     * in this template that would not be as easily debuged or fast compiled in run time
     */
    private TemplateResources templateResources = null;

    /**
     * Cg execute view object.
     *
     * @param context the context
     *
     * @return the view object
     *
     * @exception BusinessFlowException the business flow exception
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_execute(IDIFContext)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_execute(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_execute(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_execute(IDIFContext)
     */
    @Override
    public ViewObject _CG_execute(IDIFContext context) throws BusinessFlowException
    {
        return this.getTemplateResources().stageExecute(this, context);
    }

    /**
     * Cg finalize boolean.
     *
     * @param context the context
     *
     * @return the boolean
     *
     * @exception BusinessFlowException the business flow exception
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_finalize(IDIFContext)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_finalize(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_finalize(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_finalize(IDIFContext)
     */
    @Override
    public boolean _CG_finalize(IDIFContext context) throws BusinessFlowException
    {
        // Post process parameters
        __Stage__PostProcessingMethod__(context);

        // Call the wrapper to the user defined method
        return callFinalizeMethod(context);
    }

    /**
     * Cg init boolean.
     *
     * @param context the context
     *
     * @return the boolean
     *
     * @exception BusinessFlowException the business flow exception
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_init(IDIFContext) pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_init(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_init(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_init(IDIFContext)
     */
    @Override
    public boolean _CG_init(IDIFContext context) throws BusinessFlowException
    {
        // If needed inject IoC contributions
        if (this.hasInjectedContributions())
            DIFIoCRegistry.getRegistry().injectDependencies(this);

        // Init context
        this.setContext(context);

        // Initialize an empty parameter error report
        this._CG_parameterErrors = new ParameterErrors(this);

        // Initialize injected attributes
        this.__Stage__InjectedAttributesInitMethod__(context);

        // Refresh remaining parameters (created by the CustomParameters annotation)
        try
        {
            this._CG_parameterErrors.refreshParameters(this);
        }
        catch (ParameterException e)
        {
            throw new BusinessFlowException(e, context);
        }
        catch (ConfigurationException e)
        {
            throw new BusinessFlowException(e, context);
        }

        // Is called prior to the business stage init method since this initialization is the DIF internal
        // initialization process. Not dependent of the business initialization
        this.isInitialized = true;

        // Call the wrapper to the user defined method
        return callInitMethod(context);
    }

    /**
     * This method will be used by the code gen module to set the annotated attributes.
     *
     * @param difContext the context
     */
    public void __Stage__InjectedAttributesInitMethod__(IDIFContext difContext)
    {
    }

    /**
     * This method will be used by the framework to do some post processing work.
     *
     * @param difContext the context
     */
    public void __Stage__PostProcessingMethod__(IDIFContext difContext)
    {
    }

    /**
     * Add custom message.
     *
     * @param key   the key
     * @param value the value
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#addCustomMessage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#addCustomMessage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#addCustomMessage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#addCustomMessage(java.lang.String, java.lang.String)
     */
    @Override
    public void addCustomMessage(String key, String value)
    {
        if (this.__customMessages == null)
            this.__customMessages = new HashMap<String, String>();

        this.__customMessages.put(key, value);
    }

    /**
     * Allow access without valid consents boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()
     *         pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()pt.digitalis.dif.dem.interfaces.IStage#allowAccessWithoutValidConsents()
     */
    @Override
    public boolean allowAccessWithoutValidConsents()
    {
        return this._CG_proxy.allowAccessWithoutValidConsents();
    }

    /**
     * Call event method object.
     *
     * @param context   the context
     * @param type      the type
     * @param eventName the event name
     *
     * @return the object
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String) pt.digitalis.dif.dem.interfaces.IStageInstance#callEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String)pt.digitalis.dif.dem.interfaces.IStageInstance#callEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String)pt.digitalis.dif.dem.interfaces.IStageInstance#callEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String)
     */
    @Override
    public Object callEventMethod(IDIFContext context, EventType type, String eventName)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_OBJECT;
    }

    /**
     * Call execute method view object.
     *
     * @param context the context
     *
     * @return the view object
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteMethod(pt.digitalis.dif.controller.interfaces.IDIFContext)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteMethod(pt.digitalis.dif.controller.interfaces.IDIFContext)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteMethod(pt.digitalis.dif.controller.interfaces.IDIFContext)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteMethod(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    @Override
    public ViewObject callExecuteMethod(IDIFContext context)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * Call execute on event method view object.
     *
     * @param context   the context
     * @param type      the type
     * @param eventName the event name
     *
     * @return the view object
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteOnEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String) pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteOnEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String)pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteOnEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String)pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteOnEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *         pt.digitalis.dif.dem.objects.EventType, java.lang.String)
     */
    @Override
    public ViewObject callExecuteOnEventMethod(IDIFContext context, EventType type, String eventName)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * The method that will be enhanced with the call to the method annotated with <code>@Finalize</code>.
     *
     * @param context the execution context
     *
     * @return as defined on the user-defined <code>@Finalize</code>-annotated method
     */
    protected boolean callFinalizeMethod(IDIFContext context)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_BOOLEAN;
    }

    /**
     * The method that will be enhanced with the users custom parameters (call to the method annotated with
     * <code>@CustomParameters</code>.
     *
     * @param parameters the stage parameters to be customized
     */
    protected void callInitCustomParametersMethod(IParameters parameters)
    {
    }

    /**
     * The method that will be enhanced with the call to the method annotated with <code>@DIFInitializer</code>.
     *
     * @param context the execution context
     *
     * @return as defined on the user-defined <code>@DIFInitializer</code>-annotated method
     */
    protected boolean callInitMethod(IDIFContext context)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_BOOLEAN;
    }

    /**
     * Call parameter context prefix string.
     *
     * @param difRequest         the dif request
     * @param parameter          the parameter
     * @param parameterSessionID the parameter session id
     *
     * @return the string
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callParameterContextPrefix(pt.digitalis.dif.controller.interfaces.IDIFRequest,
     *         pt.digitalis.dif.dem.objects.parameters.IParameter, java.lang.String) pt.digitalis.dif.dem.interfaces.IStageInstance#callParameterContextPrefix(pt.digitalis.dif.controller.interfaces.IDIFRequest,
     *         pt.digitalis.dif.dem.objects.parameters.IParameter, java.lang.String)pt.digitalis.dif.dem.interfaces.IStageInstance#callParameterContextPrefix(pt.digitalis.dif.controller.interfaces.IDIFRequest,
     *         pt.digitalis.dif.dem.objects.parameters.IParameter, java.lang.String)pt.digitalis.dif.dem.interfaces.IStageInstance#callParameterContextPrefix(pt.digitalis.dif.controller.interfaces.IDIFRequest,
     *         pt.digitalis.dif.dem.objects.parameters.IParameter, java.lang.String)
     */
    @Override
    public String callParameterContextPrefix(IDIFRequest difRequest, IParameter<?> parameter, String parameterSessionID)
    {
        return parameterSessionID;
    }

    /**
     * Creates a new view object. For usage of the CG methods
     *
     * @param engine    the engine of the view
     * @param type      the type of the view
     * @param target    the target resource/template of the view
     * @param isDefault T if the view is the default view
     *
     * @return the created view object
     */
    protected ViewObject createView(String engine, String type, String target, boolean isDefault)
    {
        return new ViewObject(engine, ViewType.valueOf(type), target, isDefault);
    }

    /**
     * Declare feature active.
     *
     * @param featureID the feature id
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#declareFeatureActive(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#declareFeatureActive(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#declareFeatureActive(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#declareFeatureActive(java.lang.String)
     */
    @Override
    public void declareFeatureActive(String featureID)
    {
        this.getActiveStageFeatures().add(featureID);
    }

    /**
     * Inspector for the 'activeStageFeatures' attribute.
     *
     * @return the activeStageFeatures value
     */
    private List<String> getActiveStageFeatures()
    {
        if (this.activeStageFeatures == null)
            this.activeStageFeatures = new ArrayList<String>();

        return this.activeStageFeatures;
    }

    /**
     * Gets authentication error.
     *
     * @return the authentication error
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getAuthenticationError()
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#getAuthenticationError()pt.digitalis.dif.dem.interfaces.IStageInstance#getAuthenticationError()pt.digitalis.dif.dem.interfaces.IStageInstance#getAuthenticationError()
     */
    @Override
    public ControllerException getAuthenticationError()
    {
        return _CG_authenticationException;
    }

    /**
     * Sets authentication error.
     *
     * @param exception the exception
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setAuthenticationError(pt.digitalis.dif.exception.controller.ControllerException)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setAuthenticationError(pt.digitalis.dif.exception.controller.ControllerException)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setAuthenticationError(pt.digitalis.dif.exception.controller.ControllerException)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setAuthenticationError(pt.digitalis.dif.exception.controller.ControllerException)
     */
    @Override
    public void setAuthenticationError(ControllerException exception)
    {
        this._CG_authenticationException = exception;
    }

    /**
     * Gets callback type.
     *
     * @return the callback type
     *
     * @see pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType() pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()
     */
    @Override
    public CallbackType getCallbackType()
    {
        return _CG_proxy.getCallbackType();
    }

    /**
     * Gets context.
     *
     * @return the context
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getContext() pt.digitalis.dif.dem.interfaces.IStageInstance#getContext()pt.digitalis.dif.dem.interfaces.IStageInstance#getContext()pt.digitalis.dif.dem.interfaces.IStageInstance#getContext()
     */
    @Override
    public IDIFContext getContext()
    {
        return this._CG_context;
    }

    /**
     * Sets context.
     *
     * @param newContext the new context
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setContext(IDIFContext) pt.digitalis.dif.dem.interfaces.IStageInstance#setContext(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#setContext(IDIFContext)pt.digitalis.dif.dem.interfaces.IStageInstance#setContext(IDIFContext)
     */
    @Override
    public void setContext(IDIFContext newContext)
    {
        this._CG_context = newContext;
    }

    /**
     * The default error stage is constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the default error stage fetching to the _CG_proxy.
     *
     * @return the default error stage
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorStage() pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorStage()pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorStage()pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorStage()
     */
    @Override
    public IStage getDefaultErrorStage()
    {
        return this._CG_proxy.getDefaultErrorStage();
    }

    /**
     * The default error view is constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the default error view fetching to the _CG_proxy.
     *
     * @return the default error view
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorView() pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorView()pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorView()pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorView()
     */
    @Override
    public ViewObject getDefaultErrorView()
    {
        return this._CG_proxy.getDefaultErrorView();
    }

    /**
     * The default view is constant and common to all instances and as such can be placed on the _CG_proxy. This method
     * simply delegates the default view fetching to the _CG_proxy.
     *
     * @return the default view
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultView() pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultView()pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultView()pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultView()
     */
    @Override
    public ViewObject getDefaultView()
    {
        return this._CG_proxy.getDefaultView();
    }

    /**
     * Gets event handlers.
     *
     * @return the event handlers
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers() pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()
     */
    @Override
    public Map<EventType, List<String>> getEventHandlers()
    {
        return _CG_proxy.getEventHandlers();
    }

    /**
     * The ID is constant and common to all instances and as such can be placed on the _CG_proxy. This method simply
     * delegates the ID fetching to the _CG_proxy.
     *
     * @return the id
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getID() pt.digitalis.dif.dem.interfaces.IEntity#getID()pt.digitalis.dif.dem.interfaces.IEntity#getID()pt.digitalis.dif.dem.interfaces.IEntity#getID()
     */
    @Override
    public String getID()
    {
        return _CG_proxy.getID();
    }

    /**
     * Gets included message stages.
     *
     * @return the included message stages
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages() pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages()pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages()pt.digitalis.dif.dem.interfaces.IStage#getIncludedMessageStages()
     */
    @Override
    public List<String> getIncludedMessageStages()
    {
        return this._CG_proxy.getIncludedMessageStages();
    }

    /**
     * Gets injected error stages.
     *
     * @return the injected error stages
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages() pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()
     */
    @Override
    public Map<String, String> getInjectedErrorStages()
    {
        return _CG_proxy.getInjectedErrorStages();
    }

    /**
     * Gets injected error views.
     *
     * @return the injected error views
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews() pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()
     */
    @Override
    public Map<String, ViewObject> getInjectedErrorViews()
    {
        return _CG_proxy.getInjectedErrorViews();
    }

    /**
     * The injected stages are constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the injected stages fetching to the _CG_proxy.
     *
     * @return the injected stages
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedStages() pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedStages()pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedStages()pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedStages()
     */
    @Override
    public List<String> getInjectedStages()
    {
        return this._CG_proxy.getInjectedStages();
    }

    /**
     * The injected views are constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the injected views fetching to the _CG_proxy.
     *
     * @return the injected views
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedViews() pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedViews()pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedViews()pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedViews()
     */
    @Override
    public List<ViewObject> getInjectedViews()
    {
        return _CG_proxy.getInjectedViews();
    }

    /**
     * Gets instance.
     *
     * @return the instance
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInstance() pt.digitalis.dif.dem.interfaces.IStage#getInstance()pt.digitalis.dif.dem.interfaces.IStage#getInstance()pt.digitalis.dif.dem.interfaces.IStage#getInstance()
     */
    @Override
    public IStageInstance getInstance()
    {
        return this;
    }

    /**
     * Gets java script head free marker template.
     *
     * @param view the view
     *
     * @return the java script head free marker template
     */
    @Override
    public String getJavaScriptHeadFreeMarkerTemplate(ViewObject view)
    {
        return this._CG_proxy.getJavaScriptHeadFreeMarkerTemplate(view);
    }

    /**
     * Gets java script head template.
     *
     * @param view the view
     *
     * @return the java script head template
     */
    @Override
    public String getJavaScriptHeadTemplate(ViewObject view)
    {
        return this._CG_proxy.getJavaScriptHeadTemplate(view);
    }

    /**
     * Gets java script on load free marker template.
     *
     * @param view the view
     *
     * @return the java script on load free marker template
     */
    @Override
    public String getJavaScriptOnLoadFreeMarkerTemplate(ViewObject view)
    {
        return this._CG_proxy.getJavaScriptOnLoadFreeMarkerTemplate(view);
    }

    /**
     * Gets java script on load template.
     *
     * @param view the view
     *
     * @return the java script on load template
     */
    @Override
    public String getJavaScriptOnLoadTemplate(ViewObject view)
    {
        return this._CG_proxy.getJavaScriptOnLoadTemplate(view);
    }

    /**
     * Gets java script templates.
     *
     * @return the java script templates
     */
    @Override
    public Map<String, Map<String, String>> getJavaScriptTemplates()
    {
        return this._CG_proxy.getJavaScriptTemplates();
    }

    /**
     * Gets license edition.
     *
     * @return the license edition
     *
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition() pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()
     */
    @Override
    public LicenseEditionType getLicenseEdition()
    {
        return TemplateResources.getRegistrationManager().getStageEdition(this.getID());
    }

    /**
     * Gets message.
     *
     * @param messageID the message id
     *
     * @return the message
     *
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String) pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String)pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String)pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String)
     */
    @Override
    public String getMessage(String messageID)
    {
        return this.getMessages().get(messageID);
    }

    /**
     * Gets message for language.
     *
     * @param language  the language
     * @param messageID the message id
     *
     * @return the message for language
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     */
    @Override
    public String getMessageForLanguage(String language, String messageID)
    {
        return this.getMessagesForLanguage(language).get(messageID);
    }

    /**
     * Gets messages.
     *
     * @return the messages
     *
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessages() pt.digitalis.dif.dem.interfaces.IMessage#getMessages()pt.digitalis.dif.dem.interfaces.IMessage#getMessages()pt.digitalis.dif.dem.interfaces.IMessage#getMessages()
     */
    @Override
    public Map<String, String> getMessages()
    {
        Map<String, String> messagesTmp;

        if (getContext() == null || getContext().getSession() == null)
            messagesTmp = _CG_proxy
                    .getMessagesForLanguage(DIFGeneralConfigurationParameters.getInstance().getDefaultLanguage());
        else
            messagesTmp = _CG_proxy.getMessagesForLanguage(getContext().getSession().getLanguage());

        return new StageMessageMap(messagesTmp, __customMessages, this);
    }

    /**
     * Gets messages for language.
     *
     * @param language the language
     *
     * @return the messages for language
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     */
    @Override
    public Map<String, String> getMessagesForLanguage(String language)
    {
        Map<String, String> messagesTmp = _CG_proxy.getMessagesForLanguage(language);

        return new StageMessageMap(messagesTmp, __customMessages, this);
    }

    /**
     * The name is constant and common to all instances and as such can be placed on the _CG_proxy. This method simply
     * delegates the name fetching to the _CG_proxy.
     *
     * @return the name
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getName() pt.digitalis.dif.dem.interfaces.IEntity#getName()pt.digitalis.dif.dem.interfaces.IEntity#getName()pt.digitalis.dif.dem.interfaces.IEntity#getName()
     */
    @Override
    public String getName()
    {
        return _CG_proxy.getName();
    }

    /**
     * Gets original class name.
     *
     * @return the original class name
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName() pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()
     */
    @Override
    public String getOriginalClassName()
    {
        return _CG_proxy.getOriginalClassName();
    }

    /**
     * Gets overrides stage id.
     *
     * @return the overrides stage id
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID() pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()
     */
    @Override
    public String getOverridesStageID()
    {
        return _CG_proxy.getOverridesStageID();
    }

    /**
     * Gets parameter errors.
     *
     * @return the parameter errors
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getParameterErrors() pt.digitalis.dif.dem.interfaces.IStageInstance#getParameterErrors()pt.digitalis.dif.dem.interfaces.IStageInstance#getParameterErrors()pt.digitalis.dif.dem.interfaces.IStageInstance#getParameterErrors()
     */
    @Override
    public ParameterErrors getParameterErrors()
    {
        return _CG_parameterErrors;
    }

    /**
     * Sets parameter errors.
     *
     * @param errors the errors
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setParameterErrors(pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setParameterErrors(pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setParameterErrors(pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setParameterErrors(pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors)
     */
    @Override
    public void setParameterErrors(ParameterErrors errors)
    {
        _CG_parameterErrors = errors;
    }

    /**
     * Gets parameters.
     *
     * @return the parameters
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getParameters() pt.digitalis.dif.dem.interfaces.IStageInstance#getParameters()pt.digitalis.dif.dem.interfaces.IStageInstance#getParameters()pt.digitalis.dif.dem.interfaces.IStageInstance#getParameters()
     */
    @Override
    public IParameters getParameters()
    {
        if (_CG_parameters == null)
        {
            _CG_parameters = getTemplateResources().getParametersInstance(this);
            this.callInitCustomParametersMethod(_CG_parameters);

            if (_CG_hasCustomParameters)
            {
                // Process rule dependencies, after custom rule definition
                try
                {
                    for (IParameter<?> parameter : _CG_parameters.getStageParameters().getParameters().values())
                    {
                        for (IParameterRule<?> rule : parameter.getRules())
                        {
                            for (String parameterDependID : rule.getParameters())
                            {
                                IParameter<?> parameterDepend =
                                        _CG_parameters.getStageParameters().getParameters().get(parameterDependID);

                                if (parameterDepend != null &&
                                    !parameterDepend.isReferencedInARuleFromAnotherParameter())
                                    parameterDepend.setReferencedInARuleFromAnotherParameter(true);
                            }
                        }
                    }
                }
                catch (ParameterException e)
                {
                    e.printStackTrace();
                }
            }
        }

        return _CG_parameters;
    }

    /**
     * The service is constant and common to all instances and as such can be placed on the _CG_proxy. This method
     * simply delegates the service fetching to the _CG_proxy.
     *
     * @return the service
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getService() pt.digitalis.dif.dem.interfaces.IStageInstance#getService()pt.digitalis.dif.dem.interfaces.IStageInstance#getService()pt.digitalis.dif.dem.interfaces.IStageInstance#getService()
     */
    @Override
    public IService getService()
    {
        return this._CG_proxy.getService();
    }

    /**
     * Gets stage instance class name.
     *
     * @return the stage instance class name
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName() pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()
     */
    @Override
    public String getStageInstanceClassName()
    {
        return _CG_proxy.getStageInstanceClassName();
    }

    /**
     * For usage of the CG methods
     *
     * @return an instance of template resources
     */
    protected TemplateResources getTemplateResources()
    {
        if (this.templateResources == null)
            this.templateResources = TemplateResources.getInstance();

        return templateResources;
    }

    /**
     * Gets trusted parameters.
     *
     * @return the trusted parameters
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters() pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters()pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters()pt.digitalis.dif.dem.interfaces.IStage#getTrustedParameters()
     */
    @Override
    public List<String> getTrustedParameters()
    {
        return this._CG_proxy.getTrustedParameters();
    }

    /**
     * Gets uid.
     *
     * @return the uid
     *
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getUID() pt.digitalis.dif.dem.interfaces.IEntity#getUID()pt.digitalis.dif.dem.interfaces.IEntity#getUID()pt.digitalis.dif.dem.interfaces.IEntity#getUID()
     */
    @Override
    public String getUID()
    {
        return _CG_proxy.getUID();
    }

    /**
     * Has authentication boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#hasAuthentication() pt.digitalis.dif.dem.interfaces.IStageInstance#hasAuthentication()pt.digitalis.dif.dem.interfaces.IStageInstance#hasAuthentication()pt.digitalis.dif.dem.interfaces.IStageInstance#hasAuthentication()
     */
    @Override
    public boolean hasAuthentication()
    {
        return _CG_proxy.hasAuthentication();
    }

    /**
     * Has authentication error injection boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()
     *         pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()
     */
    @Override
    public boolean hasAuthenticationErrorInjection()
    {
        return _CG_proxy.hasAuthenticationErrorInjection();
    }

    /**
     * Has authorization boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization() pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()
     */
    @Override
    public boolean hasAuthorization()
    {
        return _CG_proxy.hasAuthorization();
    }

    /**
     * Has callback enabled boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled() pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()
     */
    @Override
    public boolean hasCallbackEnabled()
    {
        return _CG_proxy.hasCallbackEnabled();
    }

    /**
     * Has injected contributions boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions() pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()
     */
    @Override
    public boolean hasInjectedContributions()
    {
        return _CG_proxy.hasInjectedContributions();
    }

    /**
     * Has java script head free marker template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptHeadFreeMarkerTemplate(ViewObject view)
    {
        return this._CG_proxy.hasJavaScriptHeadFreeMarkerTemplate(view);
    }

    /**
     * Has java script head template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptHeadTemplate(ViewObject view)
    {
        return this._CG_proxy.hasJavaScriptHeadTemplate(view);
    }

    /**
     * Has java script on load free marker template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptOnLoadFreeMarkerTemplate(ViewObject view)
    {
        return this._CG_proxy.hasJavaScriptOnLoadFreeMarkerTemplate(view);
    }

    /**
     * Has java script on load template boolean.
     *
     * @param view the view
     *
     * @return the boolean
     */
    @Override
    public boolean hasJavaScriptOnLoadTemplate(ViewObject view)
    {
        return this._CG_proxy.hasJavaScriptOnLoadTemplate(view);
    }

    /**
     * Has parameter error injection boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection() pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()
     */
    @Override
    public boolean hasParameterErrorInjection()
    {
        return _CG_proxy.hasParameterErrorInjection();
    }

    /**
     * Has validation logic for form boolean.
     *
     * @param formName the form name
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     */
    @Override
    public boolean hasValidationLogicForForm(String formName)
    {
        return this._CG_proxy.hasValidationLogicForForm(formName);
    }

    /**
     * Is feature enabled boolean.
     *
     * @param featureID the feature id
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#isFeatureEnabled(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#isFeatureEnabled(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#isFeatureEnabled(java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#isFeatureEnabled(java.lang.String)
     */
    @Override
    public boolean isFeatureEnabled(String featureID)
    {
        return this.getActiveStageFeatures().contains(featureID);
    }

    /**
     * Is initialized boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#isInitialized() pt.digitalis.dif.dem.interfaces.IStageInstance#isInitialized()pt.digitalis.dif.dem.interfaces.IStageInstance#isInitialized()pt.digitalis.dif.dem.interfaces.IStageInstance#isInitialized()
     */
    @Override
    public boolean isInitialized()
    {
        return this.isInitialized;
    }

    /**
     * Is registered boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered() pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()
     */
    @Override
    public boolean isRegistered()
    {
        return _CG_proxy.isRegistered();
    }

    /**
     * Is registrable boolean.
     *
     * @return the boolean
     *
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable() pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()
     */
    @Override
    public boolean isRegistrable()
    {
        return _CG_proxy.isRegistrable();
    }

    /**
     * Register boolean.
     *
     * @param name the name
     * @param key  the key
     *
     * @return the boolean
     *
     * @exception ConfigurationException the configuration exception
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     *         pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     */
    @Override
    public boolean register(String name, String key) throws ConfigurationException
    {
        return _CG_proxy.register(name, key);
    }

    /**
     * Sets proxy.
     *
     * @param _CG_proxy the cg proxy
     *
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setProxy(pt.digitalis.dif.dem.interfaces.IStage)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setProxy(pt.digitalis.dif.dem.interfaces.IStage)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setProxy(pt.digitalis.dif.dem.interfaces.IStage)
     *         pt.digitalis.dif.dem.interfaces.IStageInstance#setProxy(pt.digitalis.dif.dem.interfaces.IStage)
     */
    @Override
    public void setProxy(IStage _CG_proxy)
    {
        this._CG_proxy = _CG_proxy;
    }

    /**
     * Unregister.
     *
     * @exception ConfigurationException the configuration exception
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#unregister() pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()
     */
    @Override
    public void unregister() throws ConfigurationException
    {
        this._CG_proxy.unregister();
    }
}