/**
 * 2017, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.codegen.templates;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 04/12/2017
 */
public class StageMessageMap extends CaseInsensitiveHashMap<String>
{

    /**
     *
     */
    private static final long serialVersionUID = 2579656518018033461L;

    /** to control when the added messages are send to the stage for safe keeping */
    private boolean addCustomMessageToStage = false;

    /** the stage to sync with */
    private IStageInstance stageInstance;

    /**
     * @param stageMessages  the stage messages
     * @param customMessages the custom messages
     * @param stageInstance  the stage to sync messages with
     */
    public StageMessageMap(Map<String, String> stageMessages, Map<String, String> customMessages,
            IStageInstance stageInstance)
    {
        this.stageInstance = stageInstance;

        if (stageMessages != null)
            super.putAll(stageMessages);

        if (customMessages != null)
            super.putAll(customMessages);

        this.addCustomMessageToStage = true;
    }

    /**
     * @see java.util.HashMap#put(java.lang.Object, java.lang.Object)
     */
    @Override
    public String put(String key, String value)
    {
        if (addCustomMessageToStage)
        {
            this.stageInstance.addCustomMessage(key, value);
        }

        return super.put(key, value);
    }

    /**
     * @see java.util.HashMap#putAll(java.util.Map)
     */
    @Override
    public void putAll(Map<? extends String, ? extends String> values)
    {
        for (Entry<? extends String, ? extends String> entry : values.entrySet())
        {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}
