/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.util;

import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.List;

/**
 * Defines a method enhancement object.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created Dec 10, 2007
 */
public class ClassMethodEnhancement implements IObjectFormatter
{

    /** the finalizer code if needed */
    String terminatorSource = "";

    /**
     * Defines if source should be appended or overwritten on each addition operation. T is for append, F for overwrite.
     */
    private boolean incrementalMode;

    /** The name of the method to enhance. */
    private String methodName;

    /** The method source. */
    private StringBuilder source = new StringBuilder();

    /**
     * Builds a new method enhancement object.
     *
     * @param methodName      the name of the method
     * @param incrementalMode defines the incremental mode
     */
    public ClassMethodEnhancement(String methodName, boolean incrementalMode)
    {
        this.methodName = methodName;
        this.incrementalMode = incrementalMode;
    }

    /**
     * Adds source to the method. If it is a non-incremental source method it will overwrite previous source code
     *
     * @param source the source to add
     */
    public void addSource(String source)
    {
        if (isIncrementalMode())
            this.source.append(source);
        else
            this.source = new StringBuilder(source);
    }

    /**
     * Returns the method name.
     *
     * @return the method name
     */
    public String getMethodName()
    {
        return methodName;
    }

    /**
     * Returns the source.
     *
     * @return the source
     */
    public String getSource()
    {
        if (terminatorSource == null || "".equals(terminatorSource))
            return source.toString();
        else
            return source.toString() + "\n" + terminatorSource;
    }

    /**
     * Modifier for the 'source' attribute.
     *
     * @param source the new source value to set
     */
    public void setSource(StringBuilder source)
    {
        this.source = source;
    }

    /**
     * Inspector for the 'incrementalMode' property.
     *
     * @return the incrementalMode property value
     */
    public boolean isIncrementalMode()
    {
        return incrementalMode;
    }

    /**
     * Adds source as the methods terminator (finalizer) code. it will overwrite previous source terminator code
     *
     * @param source the source to add
     */
    public void setTerminator(String source)
    {
        this.terminatorSource = source;
    }

    @Override
    public ObjectFormatter toObjectFormatter(ObjectFormatter.Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);

        formatter.addItem("Method Name", this.methodName);
        formatter.addItem("Incremental", incrementalMode);
        formatter.addItem("Source", source);
        formatter.addItem("Terminator Source", terminatorSource);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
