/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.codegen.util;

import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.annotations.AnnotationMemberTags;
import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.dem.annotations.entities.ApplicationDefinition;
import pt.digitalis.dif.dem.annotations.entities.ProviderDefinition;
import pt.digitalis.dif.dem.annotations.entities.ServiceDefinition;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.utils.CodeGenUtils;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.ClassHolder;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/**
 * A set of entity-inspection utilities.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/11/07
 */
final public class EntityUtils
{

    /**
     * Returns the ID of a given entity.
     *
     * @param clazz the DEM object
     *
     * @return the id of the supplied entity
     *
     * @exception ResourceNotFoundException if the annotations can't be read
     */
    static public String getEntityID(ClassHolder clazz) throws ResourceNotFoundException
    {
        String entityID = null;

        AnnotationHolder annotation = null;

        if (clazz.containsAnnotation(ProviderDefinition.class.getCanonicalName()))
            annotation = clazz.getAnnotations().get(ProviderDefinition.class.getCanonicalName());

        else if (clazz.containsAnnotation(ApplicationDefinition.class.getCanonicalName()))
            annotation = clazz.getAnnotations().get(ApplicationDefinition.class.getCanonicalName());

        else if (clazz.containsAnnotation(ServiceDefinition.class.getCanonicalName()))
            annotation = clazz.getAnnotations().get(ServiceDefinition.class.getCanonicalName());

        else if (clazz.containsAnnotation(StageDefinition.class.getCanonicalName()))
            annotation = clazz.getAnnotations().get(StageDefinition.class.getCanonicalName());

        if (annotation == null)
            return null;

        else
        {
            entityID = annotation.getMembers().get(AnnotationMemberTags.ENTITY_DEFINITION_ID).toString();

            // Check if id generation is needed...
            if (AnnotationTags.GENERATE_ID.equals(entityID))
                entityID = CodeGenUtils.generateID(clazz.getName());

            return entityID.toLowerCase();
        }
    }

    /**
     * Returns the type of the entity type of the passed argument.
     *
     * @param clazz the DEM object
     *
     * @return the entity type of the class passed as argument
     *
     * @exception ResourceNotFoundException if annotations can't be read
     */
    static public Entity getEntityType(ClassHolder clazz) throws ResourceNotFoundException
    {
        if (clazz.containsAnnotation(ProviderDefinition.class.getCanonicalName()))
        {
            return Entity.PROVIDER;
        }
        else if (clazz.containsAnnotation(ApplicationDefinition.class.getCanonicalName()))
        {
            return Entity.APPLICATION;
        }
        else if (clazz.containsAnnotation(ServiceDefinition.class.getCanonicalName()))
        {
            return Entity.SERVICE;
        }
        else if (clazz.containsAnnotation(StageDefinition.class.getCanonicalName()))
        {
            return Entity.STAGE;
        }

        return null;
    }
}
