/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.util;

import pt.digitalis.dif.dem.DEMAnnotationLogic;
import pt.digitalis.dif.exception.codegen.AnnotationMisuseException;
import pt.digitalis.dif.exception.codegen.DIFCodeGenerationException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.utils.annotations.Contribution;
import pt.digitalis.utils.bytecode.exceptions.CodeGenerationException;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.AttributeHolder;
import pt.digitalis.utils.bytecode.holders.ClassHolder;
import pt.digitalis.utils.bytecode.holders.MethodHolder;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/**
 * Defines the basic behavior that any DIF class enhancer must implement.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Jul 23, 2007
 */
@Contribution
public interface IClassEnhancer
{

    /**
     * Enhances a given class.
     *
     * @param clazz the class to enhance.
     *
     * @return the entity class for DEMRegistry addition
     *
     * @exception ResourceNotFoundException  if the class could not be loaded
     * @exception CodeGenerationException    if class could not be enhanced
     * @exception AnnotationMisuseException  if an inappropriate annotation use was made
     * @exception DIFCodeGenerationException
     * @exception ConfigurationException
     * @exception IdentityManagerException
     */
    public ClassHolder enhance(ClassHolder clazz)
            throws ResourceNotFoundException, CodeGenerationException, AnnotationMisuseException,
            DIFCodeGenerationException, IdentityManagerException, ConfigurationException;

    /**
     * Processes a given type-targeted annotation, enhancing the class with bytecode generated accordingly to the
     * annotation.
     *
     * @param classEnhancementContext the class enhancement context
     * @param annotation              the annotation used to choose the appropriate code enhancement
     * @param annotationLogic         the annotationLogic class implementation
     *
     * @exception ResourceNotFoundException  if any need resource can't be found or loaded
     * @exception CodeGenerationException    if source code can not be compiled or appended to class
     * @exception DIFCodeGenerationException
     * @exception ConfigurationException
     * @exception IdentityManagerException
     */
    public void processAnnotation(ClassEnhancementContext classEnhancementContext, AnnotationHolder annotation,
            DEMAnnotationLogic annotationLogic)
            throws ResourceNotFoundException, CodeGenerationException, DIFCodeGenerationException,
            ConfigurationException, IdentityManagerException;

    /**
     * Processes a given field-targeted annotation, enhancing the class with bytecode generated accordingly to the
     * annotation.
     *
     * @param classEnhancementContext the class enhancement context
     * @param attribute               annotated attribute
     * @param annotation              the annotation used to choose the appropriate code enhancement
     * @param annotationLogic         the annotationLogic class implementation
     *
     * @exception ResourceNotFoundException  if any need resource can't be found or loaded
     * @exception CodeGenerationException    if source code can not be compiled or appended to class
     * @exception DIFCodeGenerationException
     * @exception ConfigurationException
     */
    public void processAnnotation(ClassEnhancementContext classEnhancementContext, AttributeHolder attribute,
            AnnotationHolder annotation, DEMAnnotationLogic annotationLogic)
            throws ResourceNotFoundException, CodeGenerationException, DIFCodeGenerationException,
            ConfigurationException;

    /**
     * Processes a given method-targeted annotation, enhancing the class with bytecode generated accordingly to the
     * annotation.
     *
     * @param classEnhancementContext the class enhancement context
     * @param method                  annotated method
     * @param annotation              the annotation used to choose the appropriate code enhancement
     * @param annotationLogic         the annotationLogic class implementation
     *
     * @exception ResourceNotFoundException  if any need resource can't be found or loaded
     * @exception CodeGenerationException    if source code can not be compiled or appended to class
     * @exception DIFCodeGenerationException
     */
    public void processAnnotation(ClassEnhancementContext classEnhancementContext, MethodHolder method,
            AnnotationHolder annotation, DEMAnnotationLogic annotationLogic)
            throws ResourceNotFoundException, CodeGenerationException, DIFCodeGenerationException;
}
