/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.http;

import pt.digitalis.dif.controller.interfaces.IDIFRequest;

import java.util.ArrayList;
import java.util.List;

/**
 * Defines a set of constants used on the HTTP service requests and responses.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Dec 19, 2007
 */
public class HTTPConstants
{
    /** The HTTP parameter indicating that a stage is to be rendered in responsive ui mode. */
    final static public String RESPONSIVE_UI_MODE_PARAMETER = "responsive_ui_mode";

    /** The HTTP parameter indicating that a stage is to be retrieved in component mode. */
    final static public String AJAX_MODE_PARAMETER = "ajax_mode";

    /** The HTTP parameter indicating that we wish to retrieve an asset form the DiF's repository */
    final static public String ASSET_ID_PARAMETER = "assetID";

    /** The HTTP parameter indicating that a back request was issued */
    final static public String BACK_REQUEST = "isBackRequest";

    /** The tag used to save the client remote address in the Client Descriptor */
    public final static String CLIENT_REMOTE_ADDR = "ClientRemoteAddress";

    /** The HTTP parameter indicating that a stage is to be retrieved in component mode. */
    final static public String COMPONENT_MODE_PARAMETER = "component_mode";

    /** The suffix for use in messages that define a Help text for components */
    final static public String CONVENTIONED_HELP_SUFFIX = "Help";

    /** The suffix for use in messages that define a Hint text for components */
    final static public String CONVENTIONED_HINT_SUFFIX = "Hint";

    /** The HTTP parameter indicating that the document is an attachment */
    final static public String DOC_IS_ATTACHMENT_PARAMETER = "docIsAttachment";

    /** The HTTP parameter indicating that we wish to retrieve a document hash */
    final static public String DOCHASH_PARAMETER = "docHASH";

    /** The HTTP parameter indicating that we wish to retrieve a document form the DiF's repository */
    final static public String DOCID_PARAMETER = "docID";

    /** The Constant EMBEDDED_MODE_PARAMETER. */
    final static public String EMBEDDED_MODE_PARAMETER = "embeddedModeKey";

    /** The parameter name to indicate after successful login stage */
    final static public String ERROR_ATTRIBUTE = "errordescriptor";

    /** Event id called. */
    final static public String EVENT_ID = "_event";

    /** Form complete field names, so we know all fields to invalidate session values on form submit */
    final static public String FORM_FIELD_NAMES = "_formfieldnames";

    /** Form hidden field indicating the stage where the include stage was born. */
    final static public String FORM_PARENT_STAGE_PARAMETER = "_formparentstage";

    /** Form configuration business id for the form submit occurred. */
    final static public String FORM_SUBMIT__CONFIG_BUSINESS_ID = "_formsubmitnameconfigbusinessid";

    /** The Constant form submit and redirection. */
    final static public String FORM_SUBMIT_AND_REDIRECTION = "_formsubmitandredirection";

    /** Form id where the form submit occurred. */
    final static public String FORM_SUBMIT_NAME = "_formsubmitname";

    /** Stage id where the form submit occurred. */
    final static public String FORM_SUBMIT_STAGE = "_formsubmitstage";

    /** Form validation request identifier for validation only AJAX action. */
    final static public String FORM_VALIDATION = "_formvalidation";

    /** The HTTP parameter containing the stage name that will be invoked. */
    final static public String FORMAT_PARAMETER = "format";

    /** The HTTP parameter indicating that a stage is to be retrieved in help mode. */
    final static public String HELP_MODE_PARAMETER = "help_mode";

    /**
     *
     */
    final static public String HTTP_CHANNEL_ID = "http";

    /** The HTTP parameter indicating that the form is in insert mode. */
    final static public String INSERT_MODE_PARAMETER = "insert_mode";

    /** The HTTP parameter indicating the language. */
    final static public String LANGUAGE = "language";

    /** if T the stage has requested to add itself to the log interceptor */
    public static final String LOG_ME = "logme";

    /** The parameter indicating that a dif form in multi part has been submited. */
    final static public String MULTI_PART_DIF_FORM = "multiPartDifForm";

    /** The parameter name to indicate after successful login stage */
    final static public String ON_SUCESS_LOGIN_STAGE = "afterloginstageid";

    /** The HTTP parameter indicating that parent page script already include, in component mode. */
    final static public String PAGE_IMPORTED_IDS_PARAMETER = "pageScriptsIDs";

    /** The HTTP parameter indicating the stage where the include stage was born. */
    final static public String PARENT_STAGE_PARAMETER = "_parentstage";

    /** The HTTP parameter indicating that a stage is to be retrieved in popup mode. */
    final static public String POPUP_MODE_PARAMETER = "popup_mode";

    /** The attribute name to put DIFResponse into the HttpServletRequest. */
    final static public String RESPONSE_ATTRIBUTE = "DIFResponseAttribute";

    /** The HTTP parameter indicating that a stage was called component mode. */
    final static public String REST_URL_PARAMETER = "rest_call";

    /** The HTTP parameter containing the stage name that will be invoked. */
    final static public String STAGE_PARAMETER = "stage";

    /** The submit action parameter name */
    final static public String SUBMIT_ACTION = "submitAction";

    /** The Tab Index parameter, indicates which index the page should begin */
    final static public String TAB_INDEX_PARAMETER = "tabIndexParam";

    /** The HTTP parameter indicating that a stage is to be retrieved in template mode. */
    final static public String TEMPLATE_MODE_PARAMETER = "template_mode";

    /** the new theme ID */
    public static final String THEME_ID = "themeID";

    /** The HTTP parameter indicating that an error occurred in upload file. */
    final static public String UPLOAD_FILE_SIZE_ERROR = "Upload_File_Size_Error-";

    /** The HTTP parameter indicating the compatibility mode for Rich Web UI. */
    final static public String WEBUI_COMPAT_MODE = "webui_compat_mode";

    /** The HTTP parameter indicating the debug mode for Rich Web UI. */
    final static public String WEBUI_DEBUG_MODE = "webui_debug_mode";

    /** The HTTP parameter indicating the mode to render the web page in. */
    final static public String WEBUI_MODE = "webui_mode";

    /** The HTTP parameter indicating the message cache mode in development mode. */
    final static public String WEBUI_USE_MESSAGES_CACHE = "webui_use_messages_cache";

    /** A list of private DIF parameters that will not be saved in the breadcrumb instance */
    private static List<String> privateParameters;

    /**
     * Inspector for the 'privateParameters' attribute.
     *
     * @return the privateParameters value
     */
    public static List<String> getPrivateParameters()
    {
        if (privateParameters == null)
        {
            privateParameters = new ArrayList<String>();
            privateParameters.add(HTTPConstants.STAGE_PARAMETER);
            privateParameters.add(HTTPConstants.HELP_MODE_PARAMETER);
            privateParameters.add(HTTPConstants.COMPONENT_MODE_PARAMETER);
            privateParameters.add(HTTPConstants.FORM_SUBMIT_STAGE);
            privateParameters.add(HTTPConstants.FORM_SUBMIT_NAME);
            privateParameters.add(HTTPConstants.EVENT_ID);
            privateParameters.add(HTTPConstants.LANGUAGE);
            privateParameters.add(HTTPConstants.WEBUI_MODE);
            privateParameters.add(HTTPConstants.WEBUI_USE_MESSAGES_CACHE);
            privateParameters.add(HTTPConstants.LOG_ME);
            privateParameters.add(HTTPConstants.ON_SUCESS_LOGIN_STAGE);
            privateParameters.add(IDIFRequest.USER_PARAMETER_ID);
            privateParameters.add(IDIFRequest.PASSWORD_PARAMETER_ID);
        }

        return privateParameters;
    }
}
