/**
 * 2018, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.interceptors;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * Interceptors that will be executed before the dispatch logic takes place
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 6, 2018
 */
public interface IDIFInterceptorBeforeDispatch
{

    /**
     * Executes the necessary action before the dispatch logic takes place
     *
     * @param context the current executing context
     *
     * @exception BusinessFlowException
     * @exception ControllerException
     * @exception ConfigurationException
     */
    public void executeLogic(IDIFContext context)
            throws BusinessFlowException, ControllerException, ConfigurationException;
}
