/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.interceptors;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;

/**
 * Interceptors that will be executed before the stage execution (with all context initialized)
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 23/11/2015
 */
public interface IDIFInterpectorBeforeExecute
{

    /**
     * Custom logic to call
     *
     * @param context the current stage execution context
     *
     * @exception BusinessFlowException
     * @exception ControllerException
     */
    public void executeLogic(IDIFContext context) throws BusinessFlowException, ControllerException;
}
