/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.controller.objects.DIFResponseStatus;
import pt.digitalis.dif.controller.objects.RedirectInfo;
import pt.digitalis.dif.controller.objects.ResultMessage;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.managers.IUsageIssuesManager;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.issues.IssueType;
import pt.digitalis.dif.dem.objects.issues.UsageIssue;
import pt.digitalis.dif.utils.IObjectFormatter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * This interface hides some DIFContext details from the Stage. There are public setters on the DIFContext class that
 * would be accessible to the Stage.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/04/20
 */
public interface IDIFContext extends IObjectFormatter
{

    /**
     *
     */
    public static final String OVERRIDE_PAGE_TITLE = "overridePageTitle";

    /**
     * Adds a HTTP header to response.
     *
     * @param name  the header name
     * @param value the header value
     */
    public void addHTTPHeader(String name, String value);

    /**
     * Adds a result message to the stage result
     *
     * @param type        the message type
     * @param title       the title of the message
     * @param description the description of the message
     */
    public void addResultMessage(String type, String title, String description);

    /**
     * Adds a result message to the stage result
     *
     * @param type        the message type
     * @param title       the title of the message
     * @param description the description of the message
     * @param popupMode   if the message should be showed in popup mode (in a dialog)
     */
    public void addResultMessage(String type, String title, String description, boolean popupMode);

    /**
     * Adds a result message to the stage result
     *
     * @param type           the message type
     * @param title          the title of the message
     * @param description    the description of the message
     * @param popupMode      if the message should be showed in popup mode (in a dialog)
     * @param requireConfirm if T will require the user to confirm the message
     */
    public void addResultMessage(String type, String title, String description, boolean popupMode,
            boolean requireConfirm);

    /**
     * Adds a result message to the stage result.
     *
     * @param type        the message type
     * @param title       the title of the message
     * @param description the description of the message
     * @param mode        the mode
     */
    public void addResultMessage(String type, String title, String description, String mode);

    /**
     * Add a new result to the stage results.
     *
     * @param resultName  the name of the result
     * @param resultValue the result value
     */
    public void addStageResult(String resultName, Object resultValue);

    /**
     * Get the HTTP Headers added before in a stage.
     *
     * @return headers
     */
    public Map<String, String> getHTTPHeaders();

    /**
     * @return the language of the current context
     */
    public String getLanguage();

    /**
     * Gets the redirect count.
     *
     * @return the redirect count
     */
    public int getRedirectCount();

    /**
     * Gets the redirection list for the current request context.
     *
     * @return the redirect list
     */
    public List<RedirectInfo> getRedirectList();

    /**
     * Gets the redirection parameters.
     *
     * @return the redirection parameters
     */
    public Map<String, Object> getRedirectionParameters();

    /**
     * Inspector for the DIFRequest object
     *
     * @return the IDIFRequest
     */
    public IDIFRequest getRequest();

    /** The redirection parameters. */

    /**
     * Modifier for the DIFRequest Object
     *
     * @param difRequest the Original DifRequest
     */
    /* VALIDATE: Luis: Check if this setter should exist. */
    public void setRequest(IDIFRequest difRequest);

    /**
     * Gets the response status.
     *
     * @return the response status
     */
    public DIFResponseStatus getResponseStatus();

    /**
     * Sets the response status.
     *
     * @param status the new response status
     */
    public void setResponseStatus(DIFResponseStatus status);

    /**
     * get's the overridden title of the response page
     *
     * @return the overridden title
     */
    public String getResponseTitle();

    /**
     * Set a new title for the response page
     *
     * @param title the new title
     */
    public void setResponseTitle(String title);

    /**
     * Inspector for the 'resultMessage' attribute.
     *
     * @return the resultMessage value
     */
    public ArrayList<ResultMessage> getResultMessages();

    /**
     * Inspector for the session object.
     *
     * @return the session
     */
    public IDIFSession getSession();

    /**
     * Modifier for the session object.
     *
     * @param session the session to set
     */
    public void setSession(IDIFSession session);

    /**
     * Inspector for the current stage
     *
     * @return the current stage
     */
    public String getStage();

    /**
     * Modifier for the current stage
     *
     * @param stage the stage to set
     */
    public void setStage(String stage);

    /**
     * Get the {@link IStageInstance}
     *
     * @return {@link IStageInstance}
     */
    public IStageInstance getStageInstance();

    /**
     * Set the {@link IStageInstance}
     *
     * @param stageInstance the {@link IStageInstance}
     */
    public void setStageInstance(IStageInstance stageInstance);

    /**
     * Inspector for the stage results.
     *
     * @return the stage results map
     */
    public Map<String, Object> getStageResults();

    /**
     * Modifier for the stage results.
     *
     * @param results the results to set
     */
    public void setStageResults(Map<String, Object> results);

    /**
     * Inspector for the 'temporaryAttributes' attribute.
     *
     * @return the temporaryAttributes value
     */
    public Map<String, Object> getTemporaryAttributes();

    /**
     * Modifier for the 'temporaryAttributes' attribute.
     *
     * @param temporaryAttributes the new temporaryAttributes value to set
     */
    public void setTemporaryAttributes(Map<String, Object> temporaryAttributes);

    /**
     * Inspector for the view.
     *
     * @return the ViewObject.
     */
    public ViewObject getView();

    /**
     * Modifier for the view.
     *
     * @param view the ViewObject to set
     */
    public void setView(ViewObject view);

    /**
     * Handles the redirection.
     */
    public void handleRedirection();

    /**
     * Inspector for the redirection flag.
     *
     * @return T if redirection is scheduled, F otherwise
     */
    public boolean hasRedirection();

    /**
     * Sets the redirection stage.
     *
     * @param newStage the stage to redirect to
     */
    public void redirectTo(String newStage);

    /**
     * Sets the redirection stage.
     *
     * @param newStage                 the stage to redirect to
     * @param allowRedirectToSameStage if T allows redirect to same stage to be set
     */
    public void redirectTo(String newStage, boolean allowRedirectToSameStage);

    /**
     * Sets the redirection stage.
     *
     * @param newStage              the stage to redirect to
     * @param redirectionParameters the redirection parameters
     */
    public void redirectTo(String newStage, Map<String, Object> redirectionParameters);

    /**
     * Sets the redirection stage.
     *
     * @param allowRedirectToSameStage if T allows redirect to same stage to be set
     * @param newStage                 the stage to redirect to
     * @param redirectionParameters    the redirection parameters
     */
    public void redirectTo(String newStage, Map<String, Object> redirectionParameters,
            boolean allowRedirectToSameStage);

    /**
     * Sets the redirection stage.
     *
     * @param newStage              the stage to redirect to
     * @param redirectionParameters the redirection parameters
     */
    public void redirectTo(String newStage, String redirectionParameters);

    /**
     * Sets the redirection stage.
     *
     * @param allowRedirectToSameStage if T allows redirect to same stage to be set
     * @param newStage                 the stage to redirect to
     * @param redirectionParameters    the redirection parameters
     */
    public void redirectTo(String newStage, String redirectionParameters, boolean allowRedirectToSameStage);

    /**
     * Report an issue to the {@link IUsageIssuesManager}
     *
     * @param uID              the unique identifier for this contribution. for recurring errors not to be added
     *                         repeatedly
     * @param type             the issue type
     * @param issueDescription
     *
     * @return the generated issue
     */
    public UsageIssue reportIssue(String uID, IssueType type, String issueDescription);

    /**
     * Report an issue to the {@link IUsageIssuesManager}
     *
     * @param uID              the unique identifier for this contribution. for recurring errors not to be added
     *                         repeatedly
     * @param type             the issue type
     * @param issueDescription
     * @param exception        the raised exception
     *
     * @return the generated issue
     */
    public UsageIssue reportIssue(String uID, IssueType type, String issueDescription, Exception exception);

    /**
     * Report an issue to the {@link IUsageIssuesManager}
     *
     * @param uID              the unique identifier for this contribution. for recurring errors not to be added
     *                         repeatedly
     * @param type             the issue type
     * @param issueDescription
     * @param exception        the raised exception
     * @param showStackTrace   if the stack trace should be generated and attached to the issue description
     *
     * @return the generated issue
     */
    public UsageIssue reportIssue(String uID, IssueType type, String issueDescription, Exception exception,
            boolean showStackTrace);

    /**
     * Report an issue to the {@link IUsageIssuesManager}
     *
     * @param issue the issue descriptor
     *
     * @return the generated issue
     */
    public UsageIssue reportIssue(UsageIssue issue);
}
