/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.controller.objects.ClientDescriptor;
import pt.digitalis.dif.controller.objects.DIFUserInSession;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.utils.common.IBeanAttributes;

import java.util.Map;

/**
 * Defines a public accessible DIF Session
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 29, 2007
 */
public interface IDIFSession extends IBeanAttributes, IObjectFormatter
{

    /**
     * Stores a new attribute in the session.
     *
     * @param key   the key of the attribute
     * @param value the value of the new attribute
     */
    public void addAttribute(String key, Object value);

    /**
     * Stores a new attribute in the session.
     *
     * @param key the key of the attribute
     *
     * @return T if the attribute for the given key exists
     */
    public boolean containsAttribute(String key);

    /**
     * Retrieves a given attributes by id.
     *
     * @param key the key of the attribute
     *
     * @return the attribute value
     */
    @Override
    public Object getAttribute(String key);

    /**
     * Retrieves all session attributes.
     *
     * @return the session attributes Map
     */
    public Map<String, Object> getAttributes();

    /**
     * Sets all session attributes.
     *
     * @param attributes the session attributes to set
     */
    public void setAttributes(Map<String, Object> attributes);

    /**
     * Inspector for the 'clientDescriptor' attribute.
     *
     * @return the clientDescriptor value
     */
    public ClientDescriptor getClientDescriptor();

    /**
     * @return the language
     */
    public String getLanguage();

    /**
     * @param language the language to set
     */
    public void setLanguage(String language);

    /**
     * Provides the current session navigation history objet
     *
     * @return the navigation history object in session
     */
    public INavigationHistory getNavigationHistory();

    /**
     * Gets the number of requests.
     *
     * @return the number of requests
     */
    public Long getNumberOfRequests();

    /**
     * @return the sessionID
     */
    public String getSessionID();

    /**
     * Inspector for the session time-out value.
     *
     * @return the session time-out value
     */
    public long getSessionTimeOut();

    /**
     * Sets the session time-out value.
     *
     * @param sessionTimeOut the session time out new value to set
     */
    public void setSessionTimeOut(long sessionTimeOut);

    /**
     * Gets the user in session.
     *
     * @return the user in session
     */
    public DIFUserInSession getUser();

    /**
     * Sets the user in session.
     *
     * @param user the user to set
     */
    public void setUser(DIFUserInSession user);

    /**
     * Checks if session has timed out.
     *
     * @return T if session has timed out, F otherwise
     */
    public boolean hasTimedOut();

    /**
     * Increment requests.
     */
    public void incrementRequests();

    /**
     * Checks if the session has a logged user
     *
     * @return T if if is logged
     */
    public boolean isLogged();

    /**
     * @return T if the session has been marked for removal
     */
    public boolean isMarkedForRemoval();
}
