/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Dec 19, 2013
 */
public interface IModelManager
{

    /**
     * Get the current model manager version
     *
     * @return the current version
     *
     * @exception ConfigurationException
     */
    public String getCurrentVersion() throws ConfigurationException;

    /**
     * Get the model manager identifier
     *
     * @return the identifier
     */
    public String getSchema();

    /**
     * Validate if the model is enable
     *
     * @return <code>true</code> if the model is enable
     *
     * @exception InternalFrameworkException
     * @exception ConfigurationException
     */
    public boolean isEnabled() throws InternalFrameworkException, ConfigurationException;

    /**
     * Validate if the model is up to date
     *
     * @return <code>true</code> if the model is in the last version
     *
     * @exception ConfigurationException
     */
    public boolean isUpToDate() throws ConfigurationException;

    /**
     * Run the model update
     *
     * @exception ConfigurationException
     */
    public void updateVersion() throws ConfigurationException;
}
