/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.controller.objects.Breadcrumb;
import pt.digitalis.dif.dem.interfaces.IStageInstance;

import java.util.List;

/**
 * Tracks all navigation history for a single session
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/07/20
 */
public interface INavigationHistory
{

    /**
     * Adds a breadcrumb to the history
     *
     * @param crumb the crumb to add
     */
    public void addBreadcrumb(Breadcrumb crumb);

    /**
     * Adds a stage to the history
     *
     * @param stage the stage to add
     */
    public void addStage(IStageInstance stage);

    /**
     * Cleans up the navigation history after a logout process. Stages that are no longer accessible are discarded from
     * the list. Will parse if the current user can access each stage, or if no user logged if the stages are publicly
     * accessible.
     *
     * @param session the current user session
     */
    public void cleanUpAfterLogout(IDIFSession session);

    /**
     * @return all current gathered breadcrumbs ordered by first access time
     */
    List<Breadcrumb> getHistoryFirstAccess();

    /**
     * @return all current gathered breadcrumbs ordered by last access time
     */
    List<Breadcrumb> getHistoryLastAccessed();

    /**
     * Gets the parameters passed.
     *
     * @param stageInstance the stage instance
     *
     * @return the parameters passed
     */
    public String getParametersPassed(IStageInstance stageInstance);

    /**
     * Gets the parameters passed.
     *
     * @param stageInstance       the stage instance
     * @param parametersToDiscard the parameters to discard
     *
     * @return the parameters passed
     */
    public String getParametersPassed(IStageInstance stageInstance, String parametersToDiscard);

    /**
     * Finds the previous breadcrumb for a given stage by first access
     *
     * @param stageToFindPrevious
     *
     * @return the previous stage ID (for the given stage)
     */
    public Breadcrumb getPreviousForByFirstAccess(String stageToFindPrevious);

    /**
     * Finds the previous breadcrumb for a given stage by last access
     *
     * @param stageToFindPrevious
     *
     * @return the previous stage ID (for the given stage)
     */
    public Breadcrumb getPreviousForByLastAccess(String stageToFindPrevious);

    /**
     * @return T is the history is empty
     */
    public boolean isEmpty();

    /**
     * Removes a stage from the history
     *
     * @param stage the stage to remove
     */
    public void removeStage(String stage);
}
