/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.objects;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.Date;
import java.util.List;

/**
 * A single item in a navigation history, representing stage item
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/07/20
 */
public class Breadcrumb implements IObjectFormatter
{

    /** The session as it existed when the access took place */
    private IDIFSession difSession;

    /** the list of parsed parameters of the current stage */
    private String parameterPassed;

    /** The stage ID that was accessed */
    private String stageID;

    /** The timestamp of the stage access */
    private Date timestamp;

    /**
     * @param stageID
     */
    public Breadcrumb(String stageID)
    {
        this.stageID = stageID;
        this.timestamp = new Date();
    }

    /**
     * Inspector for the 'difSession' attribute.
     *
     * @return the difSession value
     */
    public IDIFSession getDifSession()
    {
        return difSession;
    }

    /**
     * Modifier for the 'difSession' attribute.
     *
     * @param difSession the new difSession value to set
     */
    public void setDifSession(IDIFSession difSession)
    {
        this.difSession = difSession;
    }

    /**
     * Inspector for the 'parameterPassed' attribute.
     *
     * @return the parameterPassed value
     */
    public String getParameterPassed()
    {
        return parameterPassed;
    }

    /**
     * Modifier for the 'parameterPassed' attribute.
     *
     * @param parameterPassed the new parameterPassed value to set
     */
    public void setParameterPassed(String parameterPassed)
    {
        this.parameterPassed = parameterPassed;
    }

    /**
     * Inspector for the 'stageID' attribute.
     *
     * @return the stageID value
     */
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Modifier for the 'stageID' attribute.
     *
     * @param stageID the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * Inspector for the 'timestamp' attribute.
     *
     * @return the timestamp value
     */
    public Date getTimestamp()
    {
        return timestamp;
    }

    /**
     * Modifier for the 'timestamp' attribute.
     *
     * @param timestamp the new timestamp value to set
     */
    public void setTimestamp(Date timestamp)
    {
        this.timestamp = timestamp;
    }

    /**
     * @return T if parameters are present
     */
    public boolean hasParameters()
    {
        return (parameterPassed != null && !"".equals(parameterPassed));
    }

    /**
     * Inspector that validates if the present breadcrumb has a session snapshot
     *
     * @return T id session is saved
     */
    public boolean hasSessionSnapshot()
    {
        return (difSession != null);
    }

    @Override
    public ObjectFormatter toObjectFormatter(ObjectFormatter.Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("StageID", stageID);
        formatter.addItem("Parameters", parameterPassed);
        formatter.addItem("Timestamp", timestamp);
        formatter.addItem("Session", difSession);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
