/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

/**
 * Represents a dispatcher execution step
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 21, 2007
 */
public enum ControllerExecutionStep
{

    /** Identifies the client agent */
    CHAL_CLIENT_AGENT_IDENTIFICATION,

    /** Publish results to view */
    CHAL_PUBLISH_RESULTS,

    /** Translate request from native channel request to DIF request */
    CHAL_TRANSLATE_REQUEST,

    /** Validate request in native channel form */
    CHAL_VALIDATE_REQUEST,

    /** Authentication */
    DISPATCHER_AUTHENTICATION,

    /** Authorization */
    DISPATCHER_AUTHORIZATION,

    /** Conclude */
    DISPATCHER_CONCLUDE,

    /** Create the execution context */
    DISPATCHER_CREATE_CONTEXT,

    /** Create response object */
    DISPATCHER_CREATE_RESPONSE,

    /** Stage Execution */
    DISPATCHER_EXECUTE,

    /** Redirection */
    DISPATCHER_REDIRECTION,

    /** Validate the request */
    DISPATCHER_VALIDATE_REQUEST;

    /**
     * @return the current step description
     */
    public String getDescription()
    {
        switch (this)
        {
            case CHAL_TRANSLATE_REQUEST:
                return "Specific Channel request translation to DIF Internal Request";

            case CHAL_CLIENT_AGENT_IDENTIFICATION:
                return "Identification of the client agent";

            case DISPATCHER_CREATE_CONTEXT:
                return "Create the execution context";

            case DISPATCHER_VALIDATE_REQUEST:
                return "Validate the request";

            case DISPATCHER_AUTHENTICATION:
                return "Authentication";

            case DISPATCHER_AUTHORIZATION:
                return "Authorization";

            case DISPATCHER_EXECUTE:
                return "Stage Execution (includes Init, Execute and Finalize).";

            case DISPATCHER_CONCLUDE:
                return "Conclude execution. Internal cleanup tasks";

            case DISPATCHER_REDIRECTION:
                return "Redirection process";

            case DISPATCHER_CREATE_RESPONSE:
                return "Create the DIF response object";

            case CHAL_PUBLISH_RESULTS:
                return "Publish results to view";

            default:
                return "";
        }
    }

    /**
     * @see java.lang.Enum#toString()
     */
    @Override
    public String toString()
    {
        return super.toString() + ": " + this.getDescription();
    }
}
