/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.objects;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Sep 30, 2016
 */
public class DIFRedirect
{

    /** The action. */
    private RedirectAction action;

    /** The params. */
    private Map<String, String> params = new HashMap<String, String>();

    /** The url. */
    private String url;

    /**
     * @param action
     * @param url
     */
    public DIFRedirect(RedirectAction action, String url)
    {
        super();
        this.action = action;
        this.url = url;
    }

    /**
     * Adds the parameter.
     *
     * @param key   the key
     * @param value the value
     */
    public void addParameter(String key, String value)
    {
        this.params.put(key, value);
    }

    /**
     * Inspector for the 'action' attribute.
     *
     * @return the action value
     */
    public RedirectAction getAction()
    {
        return action;
    }

    /**
     * Modifier for the 'action' attribute.
     *
     * @param action the new action value to set
     */
    public void setAction(RedirectAction action)
    {
        this.action = action;
    }

    /**
     * Inspector for the 'params' attribute.
     *
     * @return the params value
     */
    public Map<String, String> getParams()
    {
        return params;
    }

    /**
     * Modifier for the 'params' attribute.
     *
     * @param params the new params value to set
     */
    public void setParams(Map<String, String> params)
    {
        this.params = params;
    }

    /**
     * Inspector for the 'url' attribute.
     *
     * @return the url value
     */
    public String getUrl()
    {
        return url;
    }

    /**
     * Modifier for the 'url' attribute.
     *
     * @param url the new url value to set
     */
    public void setUrl(String url)
    {
        this.url = url;
    }
}
