/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/**
 * Implementation for {@link IDIFRequest}.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a>
 * @created 2007/03/16
 */
public class DIFRequest implements IDIFRequest
{

    /** The parameter that defines the central authentication implementation to use */
    public final static String CA_IMPL_REQUEST_PARAMETER_ID = "caimpl";

    /** The key to the original request stored as an attribute. */
    final static public String ORIGINAL_REQUEST = "originalRequest";

    /** REST action, if set in request. */
    RESTAction restAction = null;

    /** Ajax mode, false by default. */
    private boolean ajaxMode = false;

    /**
     * The attribute collection with the values from the original request.
     */
    private Map<String, Object> attributes = new HashMap<String, Object>();

    /** Back request mode, false by default. */
    private boolean backRequest = false;

    /** The descriptor of the client. */
    private ClientDescriptor client;

    /** Component mode, false by default. */
    private boolean componentMode = false;

    /** The embedded mode. */
    private boolean embeddedMode = false;

    /** The requested response format. */
    private String format;

    /** Help mode, false by default. */
    private boolean helpMode = false;

    /** The parameter collection with the values from the original request. */
    private Map<String, Object> parameters = new HashMap<String, Object>();

    /** Popup mode, false by default. */
    private boolean popupMode = false;

    /** REST call, false by default. */
    private boolean restCall = false;

    /** The requested stage. */
    private String stage;

    /** Template mode, false by default. */
    private boolean templateMode = false;

    /** The session. */
    private IDIFSession theSession;

    /** List of trusted parameters. */
    private List<String> trustedParameters = new ArrayList<String>();

    /**
     * Adds the attribute.
     *
     * @param attributeName  the attribute name
     * @param attributeValue the attribute value
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#addAttribute(String, Object)
     */
    @Override
    public void addAttribute(String attributeName, Object attributeValue)
    {
        attributes.put(attributeName, attributeValue);
    }

    /**
     * Adds the parameter.
     *
     * @param parameterName  the parameter name
     * @param parameterValue the parameter value
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#addParameter(String, Object)
     */
    @Override
    public void addParameter(String parameterName, Object parameterValue)
    {
        parameters.put(parameterName.toLowerCase(), parameterValue);
    }

    /**
     * Gets the attribute.
     *
     * @param name the name
     *
     * @return the attribute
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getAttribute(java.lang.String)
     */
    @Override
    public Object getAttribute(String name)
    {
        return this.attributes.get(name);
    }

    /**
     * Gets the attributes.
     *
     * @return the attributes
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getAttributes()
     */
    @Override
    public Map<String, Object> getAttributes()
    {
        return this.attributes;
    }

    /**
     * Sets the attributes.
     *
     * @param attributes the attributes
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setAttributes(Map)
     */
    @Override
    public void setAttributes(Map<String, Object> attributes)
    {
        this.attributes = attributes;
    }

    /**
     * Gets the client.
     *
     * @return the client
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getClient()
     */
    @Override
    public ClientDescriptor getClient()
    {
        return client;
    }

    /**
     * Sets the client.
     *
     * @param client the new client
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setClient(ClientDescriptor)
     */
    @Override
    public void setClient(ClientDescriptor client)
    {
        this.client = client;
    }

    /**
     * Gets the format.
     *
     * @return the format
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getFormat()
     */
    @Override
    public String getFormat()
    {
        return format;
    }

    /**
     * Sets the format.
     *
     * @param format the new format
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setFormat(java.lang.String)
     */
    @Override
    public void setFormat(String format)
    {
        this.format = format;
    }

    /**
     * Gets the parameter.
     *
     * @param name the name
     *
     * @return the parameter
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameter(java.lang.String)
     */
    @Override
    public Object getParameter(String name)
    {
        Object value = this.parameters.get(name.toLowerCase());

        if (value == null)
            value = this.parameters.get(name);

        return value;
    }

    /**
     * Gets the parameter raw value.
     *
     * @param parameterID the parameter ID
     *
     * @return the parameter raw value
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameterRawValue(java.lang.String)
     */
    @Override
    public String getParameterRawValue(String parameterID)
    {
        return ((HttpServletRequest) this.getAttribute(DIFRequest.ORIGINAL_REQUEST)).getParameter(parameterID);
    }

    /**
     * Gets the parameter values.
     *
     * @param parameterID the parameter ID
     *
     * @return the parameter values
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameterValues(java.lang.String)
     */
    @Override
    public String[] getParameterValues(String parameterID)
    {
        return ((HttpServletRequest) this.getAttribute(DIFRequest.ORIGINAL_REQUEST)).getParameterValues(parameterID);
    }

    /**
     * Gets the parameters.
     *
     * @return the parameters
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameters()
     */
    @Override
    public Map<String, Object> getParameters()
    {
        return this.parameters;
    }

    /**
     * Sets the parameters.
     *
     * @param parameters the parameters
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setParameters(Map)
     */
    @Override
    public void setParameters(Map<String, Object> parameters)
    {
        for (Entry<String, Object> entry : parameters.entrySet())
        {
            addParameter(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    /**
     * Gets the rest action.
     *
     * @return the rest action
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getRestAction()
     */
    @Override
    public RESTAction getRestAction()
    {
        return restAction;
    }

    /**
     * Sets the rest action.
     *
     * @param restAction the new rest action
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setRestAction(pt.digitalis.dif.controller.objects.RESTAction)
     */
    @Override
    public void setRestAction(RESTAction restAction)
    {
        this.restAction = restAction;
    }

    /**
     * Gets the session.
     *
     * @return the session
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getSession()
     */
    @Override
    public IDIFSession getSession()
    {
        return this.theSession;
    }

    /**
     * Sets the session.
     *
     * @param session the new session
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setSession(pt.digitalis.dif.controller.interfaces.IDIFSession)
     */
    @Override
    public void setSession(IDIFSession session)
    {
        this.theSession = session;
    }

    /**
     * Gets the stage.
     *
     * @return the stage
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getStage()
     */
    @Override
    public String getStage()
    {
        return stage;
    }

    /**
     * Sets the stage.
     *
     * @param newStage the new stage
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setStage(String)
     */
    @Override
    public void setStage(String newStage)
    {
        this.stage = newStage;
    }

    /**
     * Gets the stage proxy.
     *
     * @return the stage proxy
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getStageProxy()
     */
    @Override
    public IStage getStageProxy()
    {
        return DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class).getStage(getStage());
    }

    /**
     * Inspector for the 'trustedParameters' attribute.
     *
     * @return the trustedParameters value
     */
    public List<String> getTrustedParameters()
    {
        return trustedParameters;
    }

    /**
     * Checks if is ajax mode.
     *
     * @return true, if is ajax mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isAjaxMode()
     */
    @Override
    public boolean isAjaxMode()
    {
        return ajaxMode;
    }

    /**
     * Modifier for the 'ajaxMode' attribute.
     *
     * @param ajaxMode the new ajaxMode value to set
     */
    public void setAjaxMode(boolean ajaxMode)
    {
        this.ajaxMode = ajaxMode;
    }

    /**
     * Checks if is back request.
     *
     * @return true, if is back request
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isBackRequest()
     */
    @Override
    public boolean isBackRequest()
    {
        return backRequest;
    }

    /**
     * Modifier for the 'backRequest' attribute.
     *
     * @param backRequest the new backRequest value to set
     */
    public void setBackRequest(boolean backRequest)
    {
        this.backRequest = backRequest;
    }

    /**
     * Checks if is component mode.
     *
     * @return true, if is component mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isComponentMode()
     */
    @Override
    public boolean isComponentMode()
    {
        return componentMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setComponentMode(boolean)
     */
    @Override
    public void setComponentMode(boolean componentMode)
    {
        this.componentMode = componentMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isEmbeddedMode()
     */
    @Override
    public boolean isEmbeddedMode()
    {
        return embeddedMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setEmbeddedMode(boolean)
     */
    @Override
    public void setEmbeddedMode(boolean embeddedMode)
    {
        this.embeddedMode = embeddedMode;
    }

    /**
     * Checks if is help mode.
     *
     * @return true, if is help mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isHelpMode()
     */
    @Override
    public boolean isHelpMode()
    {
        return helpMode;
    }

    /**
     * Sets the help mode.
     *
     * @param helpMode the new help mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setHelpMode(boolean)
     */
    @Override
    public void setHelpMode(boolean helpMode)
    {
        this.helpMode = helpMode;
    }

    /**
     * Checks if is popup mode.
     *
     * @return true, if is popup mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isPopupMode()
     */
    @Override
    public boolean isPopupMode()
    {
        return popupMode;
    }

    /**
     * Sets the popup mode.
     *
     * @param popupMode the new popup mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setPopupMode(boolean)
     */
    @Override
    public void setPopupMode(boolean popupMode)
    {
        this.popupMode = popupMode;
    }

    /**
     * Inspector for the 'restCall' attribute.
     *
     * @return the restCall value
     */
    @Override
    public boolean isRestCall()
    {
        return restCall;
    }

    /**
     * Modifier for the 'restCall' attribute.
     *
     * @param restCall the new restCall value to set
     */
    public void setRestCall(boolean restCall)
    {
        this.restCall = restCall;
    }

    /**
     * Checks if is template mode.
     *
     * @return true, if is template mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isTemplateMode()
     */
    @Override
    public boolean isTemplateMode()
    {
        return templateMode;
    }

    /**
     * Sets the template mode.
     *
     * @param templateMode the new template mode
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setTemplateMode(boolean)
     */
    @Override
    public void setTemplateMode(boolean templateMode)
    {
        this.templateMode = templateMode;
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("Client", client);
        formatter.addItem("stage", stage);
        formatter.addItem("Template Mode", templateMode);
        formatter.addItem("Component Mode", componentMode);
        formatter.addItem("Embedded mode", embeddedMode);
        formatter.addItem("Popup Mode", isPopupMode());
        formatter.addItem("REST URL Mode", isRestCall());
        formatter.addItem("Help Mode", helpMode);
        formatter.addItem("Session", theSession);

        Map<String, Object> allowedAttributes = new HashMap<String, Object>();
        allowedAttributes.putAll(attributes);
        allowedAttributes.remove("PageContentAttribute");
        formatter.addItem("Attributes", allowedAttributes);

        Map<String, Object> allowedParams = new HashMap<String, Object>();
        allowedParams.putAll(parameters);
        if (allowedParams.containsKey(PASSWORD_PARAMETER_ID))
            allowedParams.put(PASSWORD_PARAMETER_ID, "*****");
        if (allowedParams.containsKey("password"))
            allowedParams.put("password", "*****");
        formatter.addItem("Parameters", allowedParams);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
