/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// TODO: Auto-generated Javadoc

/**
 * Implementation for {@link IDIFResponse}.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a>
 * @created 2007/03/16
 */
public class DIFResponse implements IDIFResponse, IObjectFormatter
{

    /** The dif response status. */
    private DIFResponseStatus difResponseStatus = null;

    /**
     * Aditional headers we can put on response. This headers will prevail over the headers already added in framework
     */
    private Map<String, String> httpHeaders = new HashMap<String, String>();

    /** the originating request. */
    private IDIFRequest request = null;

    /** the stage result messages, if any. */
    private ArrayList<ResultMessage> resultMessages = null;

    /** the executed stage instance. */
    private IStageInstance stageInstance = null;

    /** The processing result set. */
    private Map<String, Object> stageResults = new HashMap<String, Object>();

    /** the ViewObject Object. */
    private ViewObject theView = null;

    /**
     * Adds the HTTP header.
     *
     * @param name  the name
     * @param value the value
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#addHTTPHeader(java.lang.String, java.lang.String)
     */
    @Override
    public void addHTTPHeader(String name, String value)
    {
        this.httpHeaders.put(name, value);
    }

    /**
     * Adds the result message.
     *
     * @param resultMessage the result message
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#addResultMessage(pt.digitalis.dif.controller.objects.ResultMessage)
     */
    @Override
    public void addResultMessage(ResultMessage resultMessage)
    {
        if (this.resultMessages == null)
            this.resultMessages = new ArrayList<ResultMessage>();

        this.resultMessages.add(resultMessage);
    }

    /**
     * Adds the stage result.
     *
     * @param resultName  the result name
     * @param resultValue the result value
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#addStageResult(String, Object)
     */
    @Override
    public void addStageResult(String resultName, Object resultValue)
    {
        this.stageResults.put(resultName, resultValue);
    }

    /**
     * Gets the HTTP headers.
     *
     * @return the HTTP headers
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getHTTPHeaders()
     */
    @Override
    public Map<String, String> getHTTPHeaders()
    {
        return this.httpHeaders;
    }

    /**
     * Sets the HTTP headers.
     *
     * @param httpHeadersMap the http headers map
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setHTTPHeaders(java.util.Map)
     */
    @Override
    public void setHTTPHeaders(Map<String, String> httpHeadersMap)
    {
        httpHeaders.putAll(httpHeadersMap);
    }

    /**
     * Gets the request.
     *
     * @return the request
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getRequest()
     */
    @Override
    public IDIFRequest getRequest()
    {
        return request;
    }

    /**
     * Sets the request.
     *
     * @param request the new request
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setRequest(pt.digitalis.dif.controller.interfaces.IDIFRequest)
     */
    @Override
    public void setRequest(IDIFRequest request)
    {
        this.request = request;
    }

    /**
     * Gets the response status.
     *
     * @return the response status
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getResponseStatus()
     */
    @Override
    public DIFResponseStatus getResponseStatus()
    {
        return difResponseStatus;
    }

    /**
     * Sets the response status.
     *
     * @param status the new response status
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setResponseStatus(pt.digitalis.dif.controller.objects.DIFResponseStatus)
     */
    @Override
    public void setResponseStatus(DIFResponseStatus status)
    {
        this.difResponseStatus = status;
    }

    /**
     * Gets the result messages.
     *
     * @return the result messages
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getResultMessages()
     */
    @Override
    public ArrayList<ResultMessage> getResultMessages()
    {
        return resultMessages;
    }

    /**
     * Sets the result messages.
     *
     * @param resultMessages the new result messages
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setResultMessages(java.util.ArrayList)
     */
    @Override
    public void setResultMessages(ArrayList<ResultMessage> resultMessages)
    {
        this.resultMessages = resultMessages;
    }

    /**
     * Gets the stage instance.
     *
     * @return the stage instance
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getStageInstance()
     */
    @Override
    public IStageInstance getStageInstance()
    {
        return stageInstance;
    }

    /**
     * Sets the stage instance.
     *
     * @param stageInstance the new stage instance
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setStageInstance(pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public void setStageInstance(IStageInstance stageInstance)
    {
        this.stageInstance = stageInstance;
    }

    /**
     * Gets the stage result.
     *
     * @param resultName the result name
     *
     * @return the stage result
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getStageResult(String)
     */
    @Override
    public Object getStageResult(String resultName)
    {
        return this.stageResults.get(resultName);
    }

    /**
     * Gets the stage results.
     *
     * @return the stage results
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getStageResults()
     */
    @Override
    public Map<String, Object> getStageResults()
    {
        return this.stageResults;
    }

    /**
     * Sets the stage results.
     *
     * @param map the map
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setStageResults(Map)
     */
    @Override
    public void setStageResults(Map<String, Object> map)
    {
        stageResults.putAll(map);
    }

    /**
     * Gets the view.
     *
     * @return the view
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getView()
     */
    @Override
    public ViewObject getView()
    {
        return theView;
    }

    /**
     * Sets the view.
     *
     * @param newView the new view
     *
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setView(ViewObject)
     */
    @Override
    public void setView(ViewObject newView)
    {
        this.theView = newView;
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("View", theView);
        formatter.addItem("Stage Results", stageResults);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
