/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.controller.security.objects.IDIFGroup;
import pt.digitalis.dif.controller.security.objects.IDIFInternalUser;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Represents a IDIFUser in session after a successful login. This class contains a IDIFUser and the password that was
 * used by the user to login
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gon�alves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created Mar 25, 2008
 */
public class DIFUserInSession implements IDIFInternalUser, IObjectFormatter
{

    /** User attributes to remove. */
    private List<String> attributesToRemove = new ArrayList<String>();

    /** Is "default user"? */
    private boolean isDefault;

    /** the password used to login */
    private String password;

    /** The real user that was obtained from the {@link IIdentityManager} */
    private IDIFUser user;

    /**
     * @param user     the IDIFUser
     * @param password the password used to login
     */
    public DIFUserInSession(IDIFUser user, String password)
    {
        this.user = user;
        this.password = password;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#addGroupToExcludeTemporarily(java.lang.String)
     */
    @Override
    public void addGroupToExcludeTemporarily(String groupId)
    {
        user.addGroupToExcludeTemporarily(groupId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#addTempGroup(java.lang.String)
     */
    @Override
    public void addTempGroup(String groupId)
    {
        user.addTempGroup(groupId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IUserAuthorization#canAccess(pt.digitalis.dif.dem.Entity,
     *         java.lang.String)
     */
    @Override
    public boolean canAccess(Entity resourceType, String resourceId)
    {
        return user.canAccess(resourceType, resourceId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IUserAuthorization#canAccess(pt.digitalis.dif.dem.interfaces.IStage)
     */
    @Override
    public boolean canAccess(IStage stage)
    {
        return user.canAccess(stage);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#cleanCache()
     */
    @Override
    public void cleanCache()
    {
        user.cleanCache();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#containsAttribute(java.lang.String)
     */
    @Override
    public boolean containsAttribute(String id)
    {
        return user.containsAttribute(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#containsParameter(java.lang.String)
     */
    @Override
    public boolean containsParameter(String id)
    {
        return user.containsParameter(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getAttribute(java.lang.String)
     */
    @Override
    public Object getAttribute(String id)
    {
        return user.getAttribute(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getAttributes()
     */
    @Override
    public CaseInsensitiveHashMap<Object> getAttributes()
    {
        return user.getAttributes();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setAttributes(java.util.Map)
     */
    @Override
    public void setAttributes(Map<String, Object> attributes) throws InternalFrameworkException
    {
        this.user.setAttributes(attributes);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getAttributesToRemove()
     */
    @Override
    public List<String> getAttributesToRemove()
    {
        return attributesToRemove;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getEmail()
     */
    @Override
    public String getEmail()
    {
        return user.getEmail();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setEmail(java.lang.String)
     */
    @Override
    public void setEmail(String email)
    {
        user.setEmail(email);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getGroupIDs()
     */
    @Override
    public Set<String> getGroupIDs() throws IdentityManagerException
    {
        return user.getGroupIDs();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getGroups()
     */
    @Override
    public Map<String, IDIFGroup> getGroups() throws IdentityManagerException
    {
        return user.getGroups();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getGroupsHierarchy()
     */
    @Override
    public Map<String, IDIFGroup> getGroupsHierarchy() throws IdentityManagerException
    {
        return user.getGroupsHierarchy();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getID()
     */
    @Override
    public String getID()
    {
        return user.getID();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setID(java.lang.String)
     */
    @Override
    public void setID(String id)
    {
        user.setID(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getName()
     */
    @Override
    public String getName()
    {
        return user.getName();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setName(java.lang.String)
     */
    @Override
    public void setName(String name)
    {
        user.setName(name);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getNick()
     */
    @Override
    public String getNick()
    {
        return user.getNick();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setNick(java.lang.String)
     */
    @Override
    public void setNick(String nick)
    {
        user.setNick(nick);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getParameter(java.lang.String)
     */
    @Override
    public Object getParameter(String id)
    {
        return user.getParameter(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getParameters()
     */
    @Override
    public Map<String, Object> getParameters()
    {
        return user.getParameters();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setParameters(java.util.Map)
     */
    @Override
    public void setParameters(Map<String, Object> parameters)
    {
        this.user.setParameters(parameters);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFInternalUser#getPassword()
     */
    @Override
    public String getPassword()
    {
        return this.password;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setPassword(java.lang.String)
     */
    @Override
    public void setPassword(String password)
    {
        user.setPassword(password);
        this.password = password;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getProfile()
     */
    @Override
    public IDIFGroup getProfile() throws IdentityManagerException
    {
        return user.getProfile();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getProfileID()
     */
    @Override
    public String getProfileID() throws IdentityManagerException
    {
        return user.getProfileID();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setProfileID(java.lang.String)
     */
    @Override
    public void setProfileID(String profileGroupID)
    {
        user.setProfileID(profileGroupID);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getUserPreference(java.lang.String)
     */
    @Override
    public Object getUserPreference(String id) throws InternalFrameworkException
    {
        return user.getUserPreference(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getUserPreferences()
     */
    @Override
    public CaseInsensitiveHashMap<Object> getUserPreferences() throws InternalFrameworkException
    {
        return user.getUserPreferences();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#initializeAttributes(java.util.Map)
     */
    @Override
    public void initializeAttributes(Map<String, Object> attrs)
    {
        user.initializeAttributes(attrs);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#isDefault()
     */
    @Override
    public boolean isDefault()
    {
        return this.isDefault;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setDefault(boolean)
     */
    @Override
    public void setDefault(boolean isDefault)
    {
        this.isDefault = isDefault;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#isEnabled()
     */
    @Override
    public boolean isEnabled()
    {
        return user.isEnabled();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setEnabled(boolean)
     */
    @Override
    public void setEnabled(boolean enabled)
    {
        user.setEnabled(enabled);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#refresh()
     */
    @Override
    public void refresh()
    {
        user.refresh();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeAttribute(java.lang.String)
     */
    @Override
    public void removeAttribute(String id)
    {
        user.removeAttribute(id);
        attributesToRemove.add(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeGroupToExcludeTemporarily(java.lang.String)
     */
    @Override
    public void removeGroupToExcludeTemporarily(String groupId)
    {
        user.removeGroupToExcludeTemporarily(groupId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeParameter(java.lang.String)
     */
    @Override
    public void removeParameter(String id)
    {
        user.removeParameter(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeTempGroup(java.lang.String)
     */
    @Override
    public void removeTempGroup(String groupId)
    {
        user.removeTempGroup(groupId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setAttribute(java.lang.String, java.lang.Object)
     */
    @Override
    public void setAttribute(String id, Object attribute) throws InternalFrameworkException, ConfigurationException
    {
        user.setAttribute(id, attribute);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setParameter(java.lang.String, java.lang.Object)
     */
    @Override
    public void setParameter(String id, Object parameter)
    {
        user.setParameter(id, parameter);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setUserPreference(java.lang.String,
     *         java.lang.Object)
     */
    @Override
    public void setUserPreference(String id, Object attribute) throws InternalFrameworkException
    {
        user.setUserPreference(id, attribute);
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);

        formatter.addItem("ID", getID());
        formatter.addItemIfNotNull("Name", getName());
        formatter.addItemIfNotNull("Password", "*****");
        formatter.addItemIfNotNull("Nick", getNick());
        formatter.addItemIfNotNull("Email", getEmail());
        formatter.addItem("Enabled", isEnabled());
        formatter.addItemIfNotNull("Attributes", this.getAttributes());
        formatter.addItemIfNotNull("Parameters", this.getParameters());

        try
        {
            IDIFGroup profile = getProfile();
            formatter.addItem("Profile", profile);
        }
        catch (IdentityManagerException identityManagerException)
        {
            throw new RuntimeException("Could not access the user's profile on the identity manager!",
                    identityManagerException);
        }

        try
        {
            Map<String, IDIFGroup> groups = getGroups();
            formatter.addItemIfNotNull("Groups", groups);
        }
        catch (IdentityManagerException identityManagerException)
        {
            throw new RuntimeException("Could not access the user's groups on the identity manager!",
                    identityManagerException);
        }

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
