/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Defines the info of a redirection that took place in a stage execution.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Jul 2, 2019
 */
public class RedirectInfo implements IObjectFormatter
{

    /** The destination stage. */
    private String destinationStage;

    /** The request parameters. */
    private Map<String, Object> requestParameters;

    /**
     * @param destinationStage
     * @param requestParameters
     */
    public RedirectInfo(String destinationStage, Map<String, Object> requestParameters)
    {
        this.destinationStage = destinationStage;
        if (requestParameters != null)
        {
            this.requestParameters = new HashMap<String, Object>(requestParameters);
        }
        else
        {
            this.requestParameters = new HashMap<String, Object>();
        }
    }

    /**
     * @return the destinationStage
     */
    public String getDestinationStage()
    {
        return destinationStage;
    }

    /**
     * @return the requestParameters
     */
    public Map<String, Object> getRequestParameters()
    {
        return requestParameters;
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formater = new ObjectFormatter(format, dumpedObjects);
        formater.addItem("destinationStage", destinationStage);
        formater.addItem("requestParameters", requestParameters);

        return formater;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
