package pt.digitalis.dif.controller.sanitycheck;

import pt.digitalis.dif.sanitycheck.AbstractSanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;
import pt.digitalis.dif.startup.StartupCheckResult;
import pt.digitalis.dif.startup.checks.StartupCheckJavaVersion;
import pt.digitalis.utils.common.CollectionUtils;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 30 de Ago de 2011
 */
public class GeneralCheckUp extends AbstractSanityCheckTestSuite
{

    /**
     * Test the JVM Encoding
     *
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult testJavaEncoding()
    {
        TestResult result = new TestResult(ExecutionResult.FAILED);

        String encoding = (String) System.getProperties().get("file.encoding");

        if ("ISO-8859-1".equalsIgnoreCase(encoding))
        {
            result = new TestResult(ExecutionResult.PASSED);
        }
        else
        {
            result.setErrorMessage(
                    "The application must run on a JVM configured with the encoding 'ISO-8859-1'! Use the '-Dfile.encoding=ISO-8859-1' property to initialize the JVM.");
        }

        return result;
    }

    /**
     * Test the Java Version
     *
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult testJavaVersion()
    {
        StartupCheckResult checkResult = new StartupCheckJavaVersion().validate();

        TestResult result = new TestResult(checkResult.isSuccess() ? ExecutionResult.PASSED : ExecutionResult.FAILED);
        result.setErrorMessage(CollectionUtils.listToSeparatedString(checkResult.getErrors(), "<br/>"));

        return result;
    }
}
