/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.security.managers;

import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

/**
 * @author Luis Pinto <a href="lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 2019/03/12
 */
public interface IUserPreferencesManager
{

    /**
     * Gets the user preferences.
     *
     * @param userID the user ID
     *
     * @return the user preferences
     *
     * @exception InternalFrameworkException the internal framework exception
     */
    public CaseInsensitiveHashMap<Object> getUserPreferences(String userID) throws InternalFrameworkException;

    /**
     * Sets the user preferences.
     *
     * @param userID         the user ID
     * @param key            the key
     * @param parameterValue the parameter value
     *
     * @exception InternalFrameworkException the internal framework exception
     */
    public void setUserPreferences(String userID, String key, Object parameterValue) throws InternalFrameworkException;
}
