/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.security.managers.impl;

import pt.digitalis.dif.controller.interfaces.IPrivateDIFSession;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;
import pt.digitalis.dif.utils.jobs.RecurrentJob;
import pt.digitalis.dif.utils.logging.DIFLogger;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;

/**
 * Monitor thread that collects inactive sessions and discards them
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Dec 11, 2007
 */
public class SessionGarbageCollector extends RecurrentJob
{

    /** The session manager to monitor */
    private final SessionManagerImpl sessionManager;

    /**
     * @param sessionManager
     */
    public SessionGarbageCollector(SessionManagerImpl sessionManager)
    {
        this.sessionManager = sessionManager;
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#executeEachTime()
     */
    @Override
    protected boolean executeEachTime() throws Exception
    {
        try
        {
            Map<String, IPrivateDIFSession> loggedSessions = new HashMap<String, IPrivateDIFSession>();
            loggedSessions.putAll(sessionManager.getLoggedSessions());

            synchronized (sessionManager)
            {

                // Prevent NPE if there are no logged sessions
                if (loggedSessions.values().size() > 0)
                {
                    synchronized (loggedSessions)
                    {
                        for (IPrivateDIFSession session : loggedSessions.values())
                        {
                            if (session.isMarkedForRemoval() || session.hasExpiredAfterTimeOut())
                                sessionManager.removeSession(session.getSessionID());
                        }
                    }
                }
            }
            return true;
        }
        catch (ConcurrentModificationException e)
        {
            DIFLogger.getLogger()
                    .error("Could not purge DIF Sessions. Concurent access detected. Will purge on next cycle.");
            return false;
        }
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#getDefaultRunIntervalInSeconds()
     */
    @Override
    protected Long getDefaultRunIntervalInSeconds()
    {
        return DIFGeneralConfigurationParameters.getInstance().getSecondsForSessionCleanup();
    }
}
