/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.security.objects;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.List;
import java.util.Map;
import java.util.Set;

// TODO: Auto-generated Javadoc

/**
 * Default implementation for DIF group.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007 /12/04
 */
public class DIFGroupImpl implements IDIFGroup, IObjectFormatter
{

    /** The identity manager implementation. */
    static private IIdentityManager identityManager =
            DIFIoCRegistry.getRegistry().getImplementation(IIdentityManager.class);

    /** The group description. */
    private String groupDescription;

    /** The group id. */
    private String groupID;

    /** The group name. */
    private String groupName;

    /** Is "default group"?. */
    private boolean isDefault;

    /** The parent group. */
    private String parentGroup;

    /** The parent group. */
    private IDIFGroup parentGroupObj = null;

    /**
     * Default constructor.
     */
    public DIFGroupImpl()
    {
    }

    /**
     * Creates a new group based on a given one.
     *
     * @param group the group to copy data from
     */
    public DIFGroupImpl(IDIFGroup group)
    {
        this.groupID = group.getID();
        this.groupName = group.getName();
        this.groupDescription = group.getDescription();
        this.parentGroup = group.getParentGroupID();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return new DIFGroupImpl(this);
    }

    @Override
    public IDIFGroup cloneGroup()
    {
        try
        {
            return (IDIFGroup) this.clone();
        }
        catch (CloneNotSupportedException e)
        {
            return null;
        }
    }

    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DIFGroupImpl other = (DIFGroupImpl) obj;
        if (groupID == null)
        {
            if (other.groupID != null)
                return false;
        }
        else if (!groupID.equals(other.groupID))
            return false;
        return true;
    }

    @Override
    public String getDescription()
    {
        return this.groupDescription;
    }

    @Override
    public void setDescription(String newDescription)
    {
        this.groupDescription = newDescription;
    }

    @Override
    public String getID()
    {
        return this.groupID;
    }

    /**
     * Sets the id.
     *
     * @param newGroupId the new id
     *
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#setID(String)
     */
    @Override
    public void setID(String newGroupId)
    {
        this.groupID = newGroupId;
    }

    @Override
    public String getName()
    {
        return this.groupName;
    }

    @Override
    public void setName(String newName)
    {
        this.groupName = newName;
    }

    @Override
    public IDIFGroup getParentGroup() throws IdentityManagerException
    {
        if (parentGroupObj == null)
        {
            parentGroupObj = DIFGroupImpl.identityManager.getGroup(this.getParentGroupID());
        }
        return parentGroupObj;
    }

    @Override
    public String getParentGroupID()
    {
        return this.parentGroup;
    }

    @Override
    public void setParentGroupID(String newParent)
    {
        this.parentGroup = newParent;
    }

    @Override
    public Set<String> getUserIDs() throws IdentityManagerException
    {
        return identityManager.getUserIDsInGroup(groupID);
    }

    @Override
    public Map<String, IDIFUser> getUsers() throws IdentityManagerException
    {
        return identityManager.getGroupUsers(groupID);
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((groupID == null) ? 0 : groupID.hashCode());
        return result;
    }

    @Override
    public boolean isDefault()
    {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault)
    {
        this.isDefault = isDefault;
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);

        formatter.addItem("ID", getID());
        formatter.addItemIfNotNull("Name", getName());
        formatter.addItemIfNotNull("Description", getDescription());
        formatter.addItemIfNotNull("Parent Group", getParentGroupID());

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}