/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.security.objects;

import pt.digitalis.dif.exception.security.IdentityManagerException;

import java.util.Map;
import java.util.Set;

/**
 * Defines the expected behavior of a DIF group of users.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2007/12/04
 */
public interface IDIFGroup extends Cloneable
{

    /**
     * Returns a new clone of the current group
     *
     * @return the clone object
     */
    public IDIFGroup cloneGroup();

    /**
     * Returns the group description.
     *
     * @return the group description
     */
    public String getDescription();

    /**
     * Sets a new description for the group.
     *
     * @param newDescription the new group description
     */
    public void setDescription(String newDescription);

    /**
     * Returns the group id.
     *
     * @return the group id
     */
    public String getID();

    /**
     * Sets a new id for the group.
     *
     * @param newGroupId the new group id
     */
    public void setID(String newGroupId);

    /**
     * Returns the group name.
     *
     * @return the group name
     */
    public String getName();

    /**
     * Sets a new name for the group.
     *
     * @param newName the new group name
     */
    public void setName(String newName);

    /**
     * Returns the parent group.
     *
     * @return the parent group
     *
     * @exception IdentityManagerException if the parent group can't be found on the identity manager
     */
    public IDIFGroup getParentGroup() throws IdentityManagerException;

    /**
     * Returns the parent group ID.
     *
     * @return the parent group id
     */
    public String getParentGroupID();

    /**
     * Sets a new parent for the group.
     *
     * @param newParent the new parent group
     */
    public void setParentGroupID(String newParent);

    /**
     * Retrieves the list of user IDs associated with this group
     *
     * @return the groups
     *
     * @exception IdentityManagerException if the users can't be found on the identity manager
     */
    public Set<String> getUserIDs() throws IdentityManagerException;

    /**
     * Retrieves the list of users associated with this group
     *
     * @return the groups
     *
     * @exception IdentityManagerException if the users can't be found on the identity manager
     */
    public Map<String, IDIFUser> getUsers() throws IdentityManagerException;

    /**
     * A default group is a group that is created by the default configuration of the application. As such it cannot be
     * deleted. Only disabled.
     *
     * @return T if the user is a default group
     */
    public boolean isDefault();

    /**
     * Sets the group as a 'default group'.
     *
     * @param isDefault T if the group must be set as a default group, F otherwise
     */
    public void setDefault(boolean isDefault);
}
