/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation injects a message set on a metamodel element. The messages are retrieved from a file. The annotation
 * can be used on any of the following elements: <code>@ProviderDefinition</code>, <code>@ApplicationDefinition</code>,
 * <code>@ServiceDefinition</code> or <code>@StageDefinition</code>.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/11
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary({"pt.digitalis.dif.dem.annotations.entities.ServiceDefinition",
        "pt.digitalis.dif.dem.annotations.entities.StageDefinition"})
public @interface IncludeMessagesFromStages
{

    /** Name of the file that will be read in order to get the Messages. */
    String value();
}
