/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is used to indicate that the element is registrable, that is, it can only be accessed by end-users
 * that own a valid license. It can provide a default license name and thus will be automatically registered to that
 * name. If the annotation is not used the application will be freely accessible, bound to the default "DIF
 * auto-registration". If the annotation is used with a default registry name it will be unregistrable but associated to
 * this name. If the annotation is used without a default registry name, it will be unregistered and thus inaccessible.
 * <p>
 * It can be used on any element annotated with one of the following:
 * <ul>
 * <li><code>@ProviderDefinition </code></li>
 * <li><code>@ApplicationDefinition </code></li>
 * <li><code>@ServiceDefinition </code></li>
 * </ul>
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2007/05/11
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary({"pt.digitalis.dif.dem.annotations.entities.ProviderDefinition",
        "pt.digitalis.dif.dem.annotations.entities.ApplicationDefinition",
        "pt.digitalis.dif.dem.annotations.entities.ServiceDefinition"})
public @interface Registrable
{

    /** The default name to which the element is registered in the registry */
    String defaultRegisterName() default AnnotationTags.NONE;
}
