/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.entities;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.dem.annotations.metaannotations.Primary;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines a Provider class. A Provider aggregates applications.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/10
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Primary
public @interface ProviderDefinition
{

    /** Marks the Provider as the default Provider. Set to false by...default! */
    boolean defaultProvider() default false;

    /** The Provider id. The default value is the class name lower-case version. */
    String id() default AnnotationTags.GENERATE_ID;

    /** The Provider name. Mandatory field! */
    String name();
}
