/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.parameter;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.dem.annotations.metaannotations.Primary;
import pt.digitalis.dif.dem.objects.parameters.ParameterContext;
import pt.digitalis.dif.dem.objects.parameters.ParameterScope;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines a meta-model element parameter. It can be used on POJOs annotated with any of the following:
 * <code>@ProviderDefinition</code>, <code>@ApplicationDefinition</code>, <code>@ServiceDefinition</code>,
 * <code>@StageDefinition</code>.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/11
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Primary
public @interface Parameter
{

    /** Parameter constraints. */
    String constraints() default AnnotationTags.NONE;

    /** The parameter lifetime scope. */
    ParameterContext context() default ParameterContext.SERVICE;

    /** The Parameter's default value. */
    String defaultValue() default AnnotationTags.NONE;

    /** The Parameter ID. */
    String id() default AnnotationTags.GENERATE_ID;

    /** The name of the form to link to for validation purposes */
    String linkToForm() default AnnotationTags.NONE;

    /** The regexpression constraint to add */
    String[] regexp() default {};

    /** The parameter lifetime scope. */
    ParameterScope scope() default ParameterScope.REQUEST;

    /** If this parameter should be trusted and not sanitized */
    boolean trusted() default false;
}
