/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.parameter;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;
import pt.digitalis.dif.dem.objects.parameters.ParameterScope;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines the kind of persistence that a parameter can have.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2007/05/11
 * @see pt.digitalis.dif.dem.objects.parameters.IParameter
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary({"pt.digitalis.dif.dem.annotations.parameter.Parameter"})
@Deprecated
public @interface Persist
{

    /**
     * Only for USER scoped persistence. Anonymous access means an unauthenticated user. We have a session but not a
     * user logged in session. If true allows anonymous access issuing a warn and returning null. If false, forces the
     * launch of an exception on a anonymous access to a USER parameter
     */
    boolean allowAnonymous() default false;

    /** Defines the group of users that can access the parameter. */
    String groupVisibility() default AnnotationTags.DEFAULT_GROUP_VISIBILTY;

    /** The persistence option. If true the parameter persists between JVM restarts. */
    boolean repository() default false;

    /** The parameter lifetime scope. */
    ParameterScope scope() default ParameterScope.REQUEST;
}
