/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.security;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines a default User for the containing DEM entity. The annotation can be used on the following
 * elements: <code>@ApplicationDefinition</code>.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 6, 2007
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary({"pt.digitalis.dif.dem.annotations.entities.ApplicationDefinition"})
public @interface User
{

    /** List of user attributes. Key value pairs. Ex. "attr1=value1,attr2=value2..." */
    String attributes() default "";

    /** Default email for this user. Defaults to "${userName}@domain.com". */
    String email() default "";

    /** Full name for the given user. Defaults to the userName */
    String fullName() default "";

    /** List of groups that this user is associated to */
    String groups() default "";

    /** nick name for the given user. Defaults to the fullName */
    String nick() default "";

    /** Default password for the given user. Defaults to the userName */
    String password() default "";

    /** user profile group */
    String profile();

    /** user name for the given user (for login purposes) */
    String userName();
}
