/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.stage;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.dem.annotations.metaannotations.Primary;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation injects a view on a stage. The view will only be rendered if the control flow executes with success.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/11
 */
@Target({ElementType.TYPE, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Primary(
        yieldTo = "pt.digitalis.dif.dem.annotations.entities.StageDefinition, pt.digitalis.dif.dem.annotations.stage.ErrorView")
public @interface View
{

    /** Marks the view as the default view. Set to false by...default! */
    boolean defaultView() default false;

    /** Defines the view engine. Mandatory field! */
    String engine() default AnnotationTags.NONE;

    /** Defines the view id. Mandatory field! */
    String target();
}
