/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.annotations.stage.controller;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation allows the programmer to configure the Stages authentication controller step. It instructs the
 * controller to bypass any errors in this phase and allow execution of the stage. The errors will be injected into the
 * field annotated with this annotation for processing of the stage itself.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 31, 2007
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary("pt.digitalis.dif.dem.annotations.entities.StageDefinition")
public @interface InjectAuthenticationError
{
}
