/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.interfaces;

import java.util.Map;

/**
 * This interface represents an Application entity on the DEM. An Application is set of Services and is related to a
 * Provider.
 *
 * @author pviegas
 * @created 2007/04/24
 */
public interface IApplication extends IEntity, IMessage, IRegistrable
{

    /**
     * Returns the Application's provider.
     *
     * @return the Application provider
     */
    public IProvider getProvider();

    /**
     * Returns a list of all services associated to the Application.
     *
     * @return a list of all the Application services
     */
    public Map<String, IService> getServices();
}
