package pt.digitalis.dif.dem.interfaces;

import pt.digitalis.dif.dem.CallbackType;

/**
 * This interface exposes behavior related to call-back.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/05/03
 */
public interface ICallback
{

    /**
     * Returns the Entity's callback type. The default value is OFF.
     *
     * @return the callback type defined for the Entity.
     */
    public CallbackType getCallbackType();

    /**
     * Returns information about the Entity's callback state. The default value is F.
     *
     * @return T if Entity has Callback enabled, F otherwise
     */
    public boolean hasCallbackEnabled();
}
