/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.interfaces;

import pt.digitalis.dif.dem.objects.FormFieldCustomization;
import pt.digitalis.dif.exception.objects.ParameterException;

import java.util.List;
import java.util.Map;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 28/01/2014
 */
public interface ICustomFormDefinition
{

    /**
     * Inspector for the 'businessConfigurationID' attribute.
     *
     * @return the businessConfigurationID value
     */
    public String getBusinessConfigurationID();

    /**
     * Inspector for the 'customizedParameters' attribute.
     *
     * @return the customizedParameters value
     */
    public Map<String, FormFieldCustomization> getCustomizedParameters();

    /**
     * Inspector for the 'excludedParameters' attribute.
     *
     * @return the excludedParameters value
     */
    public List<String> getExcludedParameters();

    /**
     * Inspector for the 'ExcludedParametersMap' attribute.
     *
     * @return the ExcludedParametersMap value
     */
    public Map<String, FormFieldCustomization> getExcludedParametersMap();

    /**
     * Inspector for the 'formName' attribute.
     *
     * @return the formName value
     */
    public String getFormName();

    /**
     * Inspector for the 'stageID' attribute.
     *
     * @return the stageID value
     */
    public String getStageID();

    /**
     * Verify if a field is read only
     *
     * @param fieldName the field name
     *
     * @return {@link Boolean}
     *
     * @exception ParameterException if {@link ParameterException} occurrs
     */
    public Boolean isFieldReadOnly(String fieldName) throws ParameterException;

    /**
     * Verify if a field is required
     *
     * @param fieldName the field name
     *
     * @return {@link Boolean}
     *
     * @exception ParameterException if {@link ParameterException} occurrs
     */
    public Boolean isFieldRequired(String fieldName) throws ParameterException;
}
