/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.interfaces;

/**
 * This interface exposes the behavior shared by all the Entity, namely having a name, an ID and an Object (POJO).
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/03
 */
public interface IEntity
{

    /**
     * Returns the Entity ID.
     *
     * @return the Entity ID
     */
    public String getID();

    /**
     * Returns the Entity name.
     *
     * @return the Entity name
     */
    public String getName();

    /**
     * Returns the original entity class name
     *
     * @return the class name
     */
    public String getOriginalClassName();

    /**
     * Returns the entity's unique ID. The unique ID has the form "<entityType>:<entityID>".
     *
     * @return the entity's UID
     */
    public String getUID();
}
