/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.interfaces;

import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * This interface exposes behavior related to Entity registry.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/03
 */
public interface IRegistrable
{

    /**
     * Get the License Edition.
     *
     * @return {@link LicenseEditionType}
     */
    public LicenseEditionType getLicenseEdition();

    /**
     * Returns information about if the Entity is registered.
     *
     * @return T if the Entity is registered, F otherwise
     */
    public boolean isRegistered();

    /**
     * Returns information about if the Entity can be registered.
     *
     * @return T if the Entity is registrable, F otherwise
     */
    public boolean isRegistrable();

    /**
     * Registers the Entity with a given key.
     *
     * @param name the name to register to
     * @param key  the encripted registration key
     *
     * @return T if the Entity was successfully registered, F otherwise
     *
     * @exception ConfigurationException
     */
    public boolean register(String name, String key) throws ConfigurationException;

    /**
     * Unregisters the Entity.
     *
     * @exception ConfigurationException
     */
    public void unregister() throws ConfigurationException;
}
