/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.interfaces;

import java.util.Map;

/**
 * This interface represents a Service entity on the DEM. A Service is a set of Stages and is related to an Application.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author pviegas
 * @created 2007/04/24
 */
public interface IService extends IEntity, IRegistrable, IMessage
{

    /**
     * Returns the Service application.
     *
     * @return the Service application
     */
    public IApplication getApplication();

    /**
     * Returns the list of Service stages.
     *
     * @return the list of the Service stages
     */
    public Map<String, IStage> getStages();
}
