/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.interfaces;

import pt.digitalis.dif.controller.objects.DIFContext;

import java.util.List;

/**
 * This interface represents a parameter Validator on the DEM. This will be used to annotate parameter attribute that
 * will have their values validated by the specificed validator logic.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2007/04/24
 */
public interface IValidator
{

    /**
     * Returns the list of IDs of the parameters binded to the Validator.
     *
     * @return the list of binded parameters
     */
    public List<String> getBindedParameterIDs();

    /**
     * Return the Validator´s ID.
     *
     * @return the Validator's ID
     */
    public String getID();

    /**
     * Executes the Entity validation.
     *
     * @param value   the Entity to validate
     * @param context the execution context
     *
     * @return T if the Entity is valid, F otherwise
     */
    public boolean isValid(Object value, DIFContext context);
}
