/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.managers;

import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.interfaces.IProvider;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.dem.objects.parameters.ParameterList;

/**
 * Manages the DEM parameters, providing operations for access, pooling and persistence.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/06/01
 */
public interface IParameterManager
{

    /**
     * Return a parameter for the given entity
     *
     * @param entityType  the type of the entity
     * @param entityID    the id of the entity
     * @param parameterID the id of the parameter
     *
     * @return the parameter object if found
     */
    public IParameter<?> getParameter(Entity entityType, String entityID, String parameterID);

    /**
     * Returns an IParameter implementation for the given class
     *
     * @param typeClassName the class name to check
     *
     * @return an instance of IParameter
     */
    public IParameter<?> getParameterInstanceForType(String typeClassName);

    /**
     * Return the parameters for the given entity
     *
     * @param entityType the type of the entity
     * @param entityID   the id of the entity
     *
     * @return the parameter list if found
     */
    public ParameterList getParameters(Entity entityType, String entityID);

    /**
     * Gets the parameters of a given Application.
     *
     * @param application the application for which the parameters should be retrieved
     *
     * @return the application parameters
     */
    public ParameterList getParameters(IApplication application);

    /**
     * Gets the parameters of a given Provider.
     *
     * @param provider the provider for which the parameters should be retrieved
     *
     * @return the provider parameters
     */
    public ParameterList getParameters(IProvider provider);

    /**
     * Gets the parameters of a given Service.
     *
     * @param service the service for which the parameters should be retrieved
     *
     * @return the service parameters
     */
    public ParameterList getParameters(IService service);

    /**
     * Gets the parameters of a given Stage.
     *
     * @param stage the stage for which the parameters should be retrieved
     *
     * @return the stage parameters
     */
    public ParameterList getParameters(IStage stage);

    /**
     * Checks if the given className is a supported parameter type
     *
     * @param typeClassName the class name to check
     *
     * @return T is the class is supported
     */
    public boolean isParameterTypeSupported(String typeClassName);

    /**
     * Registers an entity parameter
     *
     * @param parameter the parameter to register
     */
    public void registerParameter(IParameter<?> parameter);
}
