/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers;

import pt.digitalis.dif.dem.managers.impl.HTMLTemplateItem;

import java.util.List;

/**
 * The Interface ITemplateManager.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 14/07/2016
 */
public interface ITemplateManager
{

    /**
     * @return T if the current manager has persistence capabilities and thus allows template customization by the users
     */
    public boolean allowTemplateCustomization();

    /**
     * Gets the template content.
     *
     * @param resource the resource
     * @param language the language
     *
     * @return the template content
     *
     * @exception Exception the exception
     */
    public StringBuffer getTemplateContent(String resource, String language) throws Exception;

    /**
     * Gets a list of all templates available
     *
     * @return the available template list
     *
     * @exception Exception
     */
    public List<HTMLTemplateItem> getTemplateList() throws Exception;

    /**
     * Refresh message cache
     */
    public void refreshCache();

    /**
     * Saves the new content to the persistence layer
     *
     * @param resource   the resource
     * @param language   the language
     * @param newContent the new content
     *
     * @exception Exception
     */
    public void saveTemplateContent(String resource, String language, String newContent) throws Exception;
}
