/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers;

import pt.digitalis.dif.dem.objects.issues.IssueScope;
import pt.digitalis.dif.dem.objects.issues.IssueType;
import pt.digitalis.dif.dem.objects.issues.UsageIssue;

import java.util.List;
import java.util.Map;

/**
 * Defines the expected behavior for the usage issue manager.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/11/13
 */
public interface IUsageIssuesManager
{

    /**
     * Adds an issue to the issue manager. Extended form.
     *
     * @param issueType        the issue type
     * @param issueScope       the issue scope
     * @param location         the issue location
     * @param issueDescription the issue description
     * @param exception        the exception that might associated to the issue
     */
    public void addIssue(IssueType issueType, IssueScope issueScope, String location, String issueDescription,
            Exception exception);

    /**
     * Adds an issue to the manager. Bean form.
     *
     * @param usageIssue the issue to add
     */
    public void addIssue(UsageIssue usageIssue);

    /**
     * @return a generated unique ideitifier
     */
    public String generateUID();

    /**
     * Inspector for the 'issueCounter' attribute.
     *
     * @return the issueCounter value
     */
    public Long getIssueCounter();

    /**
     * Returns all the issues on the manager.
     *
     * @return the issues on the manager
     */
    public Map<String, List<UsageIssue>> getIssues();

    /**
     * Returns the issues associated to the entity with the given UID.
     *
     * @param entityUID
     *
     * @return the issues for the given entity unique ID
     */
    public List<UsageIssue> getIssues(String entityUID);

    /**
     * Returns the issues associated to the entity with the given UID (nor entityUID but the internal generated UID).
     *
     * @param issueUID
     *
     * @return the issues for the given entity unique ID
     */
    public List<UsageIssue> getIssuesByUID(String issueUID);

    /**
     * Returns T if there are issues on the manager, F otherwise.
     *
     * @return T if there are issues on the manager, F otherwise
     */
    public boolean hasIssues();

    /**
     * Returns T if there are issues on the manager (ignoring the discarded ones if ignoreDiscarded is true), F
     * otherwise.
     *
     * @param ignoreDiscarded if T will ignore discarded usage errors
     *
     * @return T if there are issues on the manager, F otherwise
     */
    public boolean hasIssues(boolean ignoreDiscarded);

    /**
     * Returns T if there are issues for the given location, F otherwise.
     *
     * @param location the location
     *
     * @return T if there are issues related to the given location, F otherwise
     */
    public boolean hasIssues(String location);

    /**
     * Logs all issues on the manager by entity.
     */
    public void logAllIssuesByEntity();

    /**
     * Logs all issues on the manager by type.
     */
    public void logAllIssuesByType();

    /**
     * Logs all issues associated to the entity with the given UID.
     *
     * @param entityUID the entity's UID
     */
    public void logIssues(String entityUID);
}
