/*
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers.impl;

import pt.digitalis.dif.exception.UnsupportedAction;
import pt.digitalis.dif.utils.templates.TemplateUtils;
import pt.digitalis.utils.common.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * The Class TemplateManagerStaticImpl.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 14/07/2016
 */
public class TemplateManagerStaticImpl extends AbstractTemplateManager
{

    /** The resources cache. */
    protected static Map<String, Map<String, String>> resourcesCache = new HashMap<String, Map<String, String>>();

    /**
     * Allow template customization.
     *
     * @return true, if successful
     *
     * @see pt.digitalis.dif.dem.managers.ITemplateManager#allowTemplateCustomization()
     */
    @Override
    public boolean allowTemplateCustomization()
    {
        return false;
    }

    /**
     * Gets the original template content.
     *
     * @param resource the resource
     * @param language the language
     *
     * @return the original template content
     *
     * @exception Exception the exception
     */
    @Override
    protected StringBuffer doGetTemplateContent(String resource, String language) throws Exception
    {
        String resourceName = resource;
        if (StringUtils.isNotBlank(language))
        {
            resourceName = resourceName + "." + language;
        }

        String content = TemplateUtils.readResourceFromPathAsString(resourceName);

        return content == null ? null : new StringBuffer(content);
    }

    /**
     * @see pt.digitalis.dif.dem.managers.ITemplateManager#refreshCache()
     */
    @Override
    public void refreshCache()
    {
        resourcesCache = new HashMap<String, Map<String, String>>();
    }

    /**
     * Save template content.
     *
     * @param resource   the resource
     * @param language   the language
     * @param newContent the new content
     *
     * @exception Exception the exception
     * @see pt.digitalis.dif.dem.managers.ITemplateManager#saveTemplateContent(java.lang.String, java.lang.String,
     *         java.lang.String)
     */
    @Override
    public void saveTemplateContent(String resource, String language, String newContent) throws Exception
    {
        throw new UnsupportedAction("The manager does not support save!");
    }
}
